/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.dialogs;

import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.components.combobox.MediaScraperCheckComboBox;
import org.tinymediamanager.ui.components.combobox.TmmCheckComboBox;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.components.textfield.ReadOnlyTextArea;
import org.tinymediamanager.ui.dialogs.TmmDialog;

public class TvShowDownloadSubtitleDialog
extends TmmDialog {
    private final MediaScraperCheckComboBox cbSubtitleScraper;
    private final TmmCheckComboBox<MediaLanguages> cbLanguage;
    private final JCheckBox chckbxForceBestSubtitle;
    private boolean startDownload = false;

    public TvShowDownloadSubtitleDialog(String title) {
        super(title, "downloadSubtitle");
        JPanel panelCenter = new JPanel();
        this.getContentPane().add((Component)panelCenter, "Center");
        panelCenter.setLayout((LayoutManager)new MigLayout("", "[16lp!][][300lp:300lp,grow]", "[][][][10lp:n][]"));
        TmmLabel lblScraper = new TmmLabel(TmmResourceBundle.getString("scraper"));
        panelCenter.add((Component)lblScraper, "cell 0 0 2 1");
        this.cbSubtitleScraper = new MediaScraperCheckComboBox(TvShowModuleManager.getInstance().getTvShowList().getAvailableSubtitleScrapers());
        panelCenter.add((Component)this.cbSubtitleScraper, "cell 2 0,growx,wmin 0");
        TmmLabel lblLanguage = new TmmLabel(TmmResourceBundle.getString("metatag.language"));
        panelCenter.add((Component)lblLanguage, "cell 0 1 2 1");
        this.cbLanguage = new TmmCheckComboBox<MediaLanguages>(MediaLanguages.valuesSorted());
        panelCenter.add(this.cbLanguage, "cell 2 1,growx,wmin 0");
        ReadOnlyTextArea taHint = new ReadOnlyTextArea(TmmResourceBundle.getString("tvshow.download.subtitles.hint"));
        panelCenter.add((Component)taHint, "cell 1 2 2 1,growx,wmin 0");
        this.chckbxForceBestSubtitle = new JCheckBox(TmmResourceBundle.getString("subtitle.download.force"));
        this.chckbxForceBestSubtitle.setToolTipText(TmmResourceBundle.getString("subtitle.download.force.desc"));
        panelCenter.add((Component)this.chckbxForceBestSubtitle, "cell 1 4 2 1");
        JButton btnCancel = new JButton(TmmResourceBundle.getString("Button.cancel"));
        btnCancel.setIcon(IconManager.CANCEL_INV);
        btnCancel.addActionListener(e -> {
            this.startDownload = false;
            this.setVisible(false);
        });
        this.addButton(btnCancel);
        JButton btnStart = new JButton(TmmResourceBundle.getString("scraper.start"));
        btnStart.setIcon(IconManager.APPLY_INV);
        btnStart.addActionListener(e -> {
            this.startDownload = true;
            this.setVisible(false);
        });
        this.addDefaultButton(btnStart);
        ArrayList<MediaScraper> selectedSubtitleScrapers = new ArrayList<MediaScraper>();
        for (MediaScraper subtitleScraper : TvShowModuleManager.getInstance().getTvShowList().getAvailableSubtitleScrapers()) {
            if (!TvShowModuleManager.getInstance().getSettings().getSubtitleScrapers().contains(subtitleScraper.getId())) continue;
            selectedSubtitleScrapers.add(subtitleScraper);
        }
        if (!selectedSubtitleScrapers.isEmpty()) {
            this.cbSubtitleScraper.setSelectedItems(selectedSubtitleScrapers);
        }
        this.cbLanguage.setSelectedItems(Collections.singletonList(TvShowModuleManager.getInstance().getSettings().getSubtitleScraperLanguage()));
        this.chckbxForceBestSubtitle.setSelected(TvShowModuleManager.getInstance().getSettings().getSubtitleForceBestMatch());
    }

    public List<MediaScraper> getSubtitleScrapers() {
        return new ArrayList<MediaScraper>(this.cbSubtitleScraper.getSelectedItems());
    }

    public List<MediaLanguages> getLanguages() {
        return this.cbLanguage.getSelectedItems();
    }

    public boolean isForceBestMatch() {
        return this.chckbxForceBestSubtitle.isSelected();
    }

    public boolean shouldStartDownload() {
        return this.startDownload;
    }
}

