/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.filters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.SwingUtilities;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.ui.AbstractTmmUIFilter;
import org.tinymediamanager.ui.ITmmUIFilter;
import org.tinymediamanager.ui.components.tree.TmmTreeNode;
import org.tinymediamanager.ui.tvshows.filters.ITvShowUIFilter;

abstract class AbstractTvShowUIFilter
extends AbstractTmmUIFilter<TmmTreeNode>
implements ITvShowUIFilter<TmmTreeNode> {
    AbstractTvShowUIFilter() {
    }

    @Override
    public boolean isActive() {
        switch (this.getFilterState()) {
            case ACTIVE: 
            case ACTIVE_NEGATIVE: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean accept(TmmTreeNode node) {
        if (this.getFilterState() == ITmmUIFilter.FilterState.INACTIVE) {
            return true;
        }
        Object userObject = node.getUserObject();
        if (userObject instanceof TvShow) {
            TvShow tvShow = (TvShow)userObject;
            if (this.getFilterState() == ITmmUIFilter.FilterState.ACTIVE) {
                return this.accept(tvShow, new ArrayList<TvShowEpisode>(tvShow.getEpisodesForDisplay()));
            }
            if (this.getFilterState() == ITmmUIFilter.FilterState.ACTIVE_NEGATIVE) {
                return this.accept(tvShow, new ArrayList<TvShowEpisode>(tvShow.getEpisodesForDisplay()), true);
            }
        } else if (userObject instanceof TvShowSeason) {
            TvShowSeason season = (TvShowSeason)userObject;
            if (this.getFilterState() == ITmmUIFilter.FilterState.ACTIVE) {
                return this.accept(season.getTvShow(), season.getEpisodesForDisplay());
            }
            if (this.getFilterState() == ITmmUIFilter.FilterState.ACTIVE_NEGATIVE) {
                return this.accept(season.getTvShow(), season.getEpisodesForDisplay(), true);
            }
        } else if (userObject instanceof TvShowEpisode) {
            TvShowEpisode episode = (TvShowEpisode)userObject;
            if (this.getFilterState() == ITmmUIFilter.FilterState.ACTIVE) {
                return this.accept(episode.getTvShow(), Collections.singletonList(episode));
            }
            if (this.getFilterState() == ITmmUIFilter.FilterState.ACTIVE_NEGATIVE) {
                return this.accept(episode.getTvShow(), Collections.singletonList(episode), true);
            }
        }
        return true;
    }

    private boolean accept(TvShow tvShow, List<TvShowEpisode> episodes) {
        return this.accept(tvShow, episodes, false);
    }

    protected abstract boolean accept(TvShow var1, List<TvShowEpisode> var2, boolean var3);

    @Override
    protected void filterChanged() {
        SwingUtilities.invokeLater(() -> this.firePropertyChange("treeFilterChanged", this.checkBox.isSelected(), !this.checkBox.isSelected()));
    }
}

