/*
 * Decompiled with CFR 0.152.
 */
package de.timroes.axmlrpc;

import de.timroes.axmlrpc.XMLRPCException;
import de.timroes.axmlrpc.serializer.SerializerHandler;
import de.timroes.axmlrpc.xmlcreator.SimpleXMLCreator;
import de.timroes.axmlrpc.xmlcreator.XmlElement;

public class Call {
    private String method;
    private Object[] params;
    private final SerializerHandler serializerHandler;

    public Call(SerializerHandler serializerHandler, String method) {
        this(serializerHandler, method, null);
    }

    public Call(SerializerHandler serializerHandler, String method, Object[] params) {
        this.method = method;
        this.params = params;
        this.serializerHandler = serializerHandler;
    }

    public String getXML(boolean debugMode) throws XMLRPCException {
        SimpleXMLCreator creator = new SimpleXMLCreator();
        XmlElement methodCall = new XmlElement("methodCall");
        creator.setRootElement(methodCall);
        XmlElement methodName = new XmlElement("methodName");
        methodName.setContent(this.method);
        methodCall.addChildren(methodName);
        if (this.params != null && this.params.length > 0) {
            XmlElement callParams = new XmlElement("params");
            methodCall.addChildren(callParams);
            for (Object o : this.params) {
                callParams.addChildren(this.getXMLParam(o));
            }
        }
        String result = creator.toString();
        if (debugMode) {
            System.out.println(result);
        }
        return result;
    }

    private XmlElement getXMLParam(Object o) throws XMLRPCException {
        XmlElement param = new XmlElement("param");
        XmlElement value = new XmlElement("value");
        param.addChildren(value);
        value.addChildren(this.serializerHandler.serialize(o));
        return param;
    }
}

