/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.jsonrpc.notification;

import com.fasterxml.jackson.databind.node.ObjectNode;
import org.tinymediamanager.jsonrpc.notification.PlayerEvent;
import org.tinymediamanager.jsonrpc.notification.SystemEvent;
import org.tinymediamanager.jsonrpc.notification.VideoLibrary;

public abstract class AbstractEvent {
    public final String sender;

    public AbstractEvent(ObjectNode objectNode) {
        this.sender = objectNode.get("sender").asText();
    }

    public abstract int getId();

    public abstract String getMethod();

    public static AbstractEvent parse(ObjectNode objectNode) {
        String string = objectNode.get("method").asText();
        ObjectNode objectNode2 = (ObjectNode)objectNode.get("params");
        if (string.equals("Player.OnPlay")) {
            return new PlayerEvent.Play(objectNode2);
        }
        if (string.equals("Player.OnPause")) {
            return new PlayerEvent.Pause(objectNode2);
        }
        if (string.equals("Player.OnStop")) {
            return new PlayerEvent.Stop(objectNode2);
        }
        if (string.equals("Player.OnSpeedChanged")) {
            return new PlayerEvent.SpeedChanged(objectNode2);
        }
        if (string.equals("Player.OnSeek")) {
            return new PlayerEvent.Seek(objectNode2);
        }
        if (string.equals("System.OnQuit")) {
            return new SystemEvent.Quit(objectNode2);
        }
        if (string.equals("System.OnRestart")) {
            return new SystemEvent.Restart(objectNode2);
        }
        if (string.equals("System.OnWake")) {
            return new SystemEvent.Wake(objectNode2);
        }
        if (string.equals("System.OnLowBattery")) {
            return new SystemEvent.LowBattery(objectNode2);
        }
        if (string.equals("VideoLibrary.OnScanFinished")) {
            return new VideoLibrary.OnScanFinished(objectNode2);
        }
        if (string.equals("VideoLibrary.OnScanStarted")) {
            return new VideoLibrary.OnScanStarted(objectNode2);
        }
        return null;
    }

    public static int parseInt(ObjectNode objectNode, String string) {
        return objectNode.has(string) ? objectNode.get(string).asInt() : -1;
    }

    public static String parseString(ObjectNode objectNode, String string) {
        return objectNode.has(string) ? objectNode.get(string).asText() : null;
    }
}

