/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.library.bluray.id;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import org.tinymediamanager.library.bluray.id.Id;
import org.tinymediamanager.library.bluray.id.IdReader;
import org.tinymediamanager.library.bluray.id.IdWriter;

public class Main {
    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 2) {
            System.out.println("Missing input and output arguments");
            Main.usage();
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        if (!string.toLowerCase().endsWith(".xml") && !string.toLowerCase().endsWith(".bdmv") || !string2.toLowerCase().endsWith(".xml") && !string2.toLowerCase().endsWith(".bdmv")) {
            System.out.println("Input and output can only have xml or bdmv extension.");
            Main.usage();
        }
        if (!new File(string).exists()) {
            System.out.println("File " + string + " not found.");
            Main.usage();
        }
        Id id = null;
        FileInputStream fileInputStream = new FileInputStream(string);
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(fileInputStream));
        id = string.toLowerCase().endsWith("xml") ? new IdReader().readXml(dataInputStream) : new IdReader().readId(dataInputStream);
        dataInputStream.close();
        FileOutputStream fileOutputStream = new FileOutputStream(string2);
        DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(fileOutputStream));
        if (string2.toLowerCase().endsWith("xml")) {
            new IdWriter().writeXml(id, dataOutputStream);
        } else {
            new IdWriter().writeId(id, dataOutputStream);
        }
        dataOutputStream.close();
    }

    public static void usage() {
        System.out.println("\n\nThis is a tool to convert id.bdmv to an xml format and back.\n\n");
        System.out.println("Usage:");
        System.out.println("\n" + Main.class.getName() + " Input Output \n");
        System.out.println("where Input can be one of");
        System.out.println("   location of id.bdmv");
        System.out.println("   location of id.xml");
        System.out.println("and the Output can be one of");
        System.out.println("   id.bdmv");
        System.out.println("   id.xml");
        System.exit(1);
    }
}

