/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.swing.DefaultEventSelectionModel;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.core.AbstractSettings;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.TmmProperties;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.bus.EventBus;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.movies.MovieMatcherEditor;
import org.tinymediamanager.ui.movies.filters.IMovieUIFilter;

public class MovieSelectionModel
extends AbstractModelObject
implements ListSelectionListener {
    public static final String SELECTED_MOVIE = "selectedMovie";
    public static final String SELECTED_MOVIES = "selectedMovies";
    public final Movie initialMovie = new Movie();
    private EventList<Movie> selectedMovies;
    private Movie selectedMovie;
    private DefaultEventSelectionModel<Movie> selectionModel;
    private MovieMatcherEditor matcherEditor;
    private PropertyChangeListener propertyChangeListener;

    public MovieSelectionModel(EventList<Movie> source, MovieMatcherEditor matcher) {
        this.constructInitialMovie();
        this.selectionModel = new DefaultEventSelectionModel(source);
        this.selectionModel.addListSelectionListener((ListSelectionListener)this);
        this.matcherEditor = matcher;
        this.selectedMovies = this.selectionModel.getSelected();
        EventBus.registerListener(EventBus.TOPIC_MOVIES, event -> {
            Movie movie;
            Object patt3221$temp = event.sender();
            if (patt3221$temp instanceof Movie && (movie = (Movie)patt3221$temp) == this.selectedMovie) {
                if (event.eventType().equals("remove")) {
                    this.setSelectedMovie(this.initialMovie);
                } else {
                    this.firePropertyChange(SELECTED_MOVIE, null, movie);
                }
            }
        });
        this.propertyChangeListener = evt -> {
            if (evt.getSource() instanceof IMovieUIFilter) {
                this.firePropertyChange("filterChanged", null, evt.getSource());
            }
        };
    }

    public MovieSelectionModel() {
        this.constructInitialMovie();
    }

    private void constructInitialMovie() {
        MediaFile fakeVideo = new MediaFile();
        fakeVideo.setType(MediaFileType.VIDEO);
        this.initialMovie.addToMediaFiles(fakeVideo);
    }

    public synchronized void setSelectedMovie(Movie movie) {
        Movie oldValue = this.selectedMovie;
        this.selectedMovie = Objects.requireNonNullElse(movie, this.initialMovie);
        if (oldValue != null) {
            oldValue.removePropertyChangeListener(this.propertyChangeListener);
        }
        if (this.selectedMovie != null) {
            this.selectedMovie.addPropertyChangeListener(this.propertyChangeListener);
        }
        this.firePropertyChange(SELECTED_MOVIE, oldValue, this.selectedMovie);
    }

    public MovieMatcherEditor getMatcherEditor() {
        return this.matcherEditor;
    }

    public DefaultEventSelectionModel<Movie> getSelectionModel() {
        return this.selectionModel;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Movie oldValue;
        if (e.getValueIsAdjusting()) {
            return;
        }
        if (!this.selectedMovies.isEmpty() && this.selectedMovie != this.selectedMovies.get(0)) {
            oldValue = this.selectedMovie;
            this.selectedMovie = (Movie)this.selectedMovies.get(0);
            if (oldValue != null && oldValue != this.initialMovie) {
                oldValue.removePropertyChangeListener(this.propertyChangeListener);
            }
            if (this.selectedMovie != null && this.selectedMovie != this.initialMovie) {
                this.selectedMovie.addPropertyChangeListener(this.propertyChangeListener);
            }
            this.firePropertyChange(SELECTED_MOVIE, oldValue, this.selectedMovie);
        }
        if (this.selectedMovies.isEmpty()) {
            oldValue = this.selectedMovie;
            this.selectedMovie = this.initialMovie;
            if (oldValue != null && oldValue != this.initialMovie) {
                oldValue.removePropertyChangeListener(this.propertyChangeListener);
            }
            this.firePropertyChange(SELECTED_MOVIE, oldValue, this.selectedMovie);
        }
        this.firePropertyChange(SELECTED_MOVIES, null, this.selectedMovies);
    }

    public Movie getSelectedMovie() {
        if (this.selectedMovie == null) {
            return this.initialMovie;
        }
        return this.selectedMovie;
    }

    public List<Movie> getSelectedMovies() {
        return this.getSelectedMovies(false);
    }

    public List<Movie> getSelectedMovies(boolean withLocked) {
        if (withLocked) {
            return new ArrayList<Movie>((Collection<Movie>)this.selectedMovies);
        }
        boolean lockedFound = this.selectedMovies.parallelStream().anyMatch(MediaEntity::isLocked);
        if (lockedFound && Boolean.FALSE.equals(TmmProperties.getInstance().getPropertyAsBoolean("movie.hidelockedhint"))) {
            JCheckBox checkBox = new JCheckBox(TmmResourceBundle.getString("tmm.donotshowagain"));
            TmmFontHelper.changeFont((JComponent)checkBox, 0.91667);
            checkBox.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
            Object[] params = new Object[]{TmmResourceBundle.getString("movie.lockedfound.desc"), checkBox};
            JOptionPane.showMessageDialog(MainWindow.getInstance(), params, TmmResourceBundle.getString("movie.lockedfound"), 1);
            if (checkBox.isSelected()) {
                TmmProperties.getInstance().putProperty("movie.hidelockedhint", String.valueOf(checkBox.isSelected()));
            }
        }
        return this.selectedMovies.stream().filter(movie -> !movie.isLocked()).collect(Collectors.toList());
    }

    public void setSelectedMovies(List<Movie> selectedMovies) {
        this.selectedMovies.clear();
        if (ListUtils.isNotEmpty(selectedMovies)) {
            this.selectedMovies.addAll(selectedMovies);
        }
    }

    public void addFilter(IMovieUIFilter filter) {
        this.matcherEditor.addFilter(filter);
        filter.addPropertyChangeListener(this.propertyChangeListener);
    }

    public void setFiltersActive(boolean filtersActive) {
        this.matcherEditor.setFiltersActive(filtersActive);
        this.firePropertyChange("filterChanged", null, this.matcherEditor.getFilters());
    }

    public boolean isFiltersActive() {
        return this.matcherEditor.isFiltersActive();
    }

    public void setFilterValues(List<AbstractSettings.UIFilters> values) {
        if (values == null) {
            values = Collections.emptyList();
        }
        this.matcherEditor.setFilterValues(values);
        this.firePropertyChange("filterChanged", null, values);
    }

    public void clearFilters() {
        this.matcherEditor.clearFilters();
        this.firePropertyChange("filterChanged", null, Collections.emptyList());
    }
}

