/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model.meta;

import java.util.ArrayList;
import java.util.List;
import org.jupnp.model.ModelUtil;
import org.jupnp.model.Validatable;
import org.jupnp.model.ValidationError;
import org.jupnp.model.meta.Service;
import org.jupnp.model.meta.StateVariableEventDetails;
import org.jupnp.model.meta.StateVariableTypeDetails;
import org.jupnp.model.types.Datatype;
import org.jupnp.util.SpecificationViolationReporter;

public class StateVariable<S extends Service>
implements Validatable {
    private final String name;
    private final StateVariableTypeDetails type;
    private final StateVariableEventDetails eventDetails;
    private S service;

    public StateVariable(String name, StateVariableTypeDetails type) {
        this(name, type, new StateVariableEventDetails());
    }

    public StateVariable(String name, StateVariableTypeDetails type, StateVariableEventDetails eventDetails) {
        this.name = name;
        this.type = type;
        this.eventDetails = eventDetails;
    }

    public String getName() {
        return this.name;
    }

    public StateVariableTypeDetails getTypeDetails() {
        return this.type;
    }

    public StateVariableEventDetails getEventDetails() {
        return this.eventDetails;
    }

    public S getService() {
        return this.service;
    }

    void setService(S service) {
        if (this.service != null) {
            throw new IllegalStateException("Final value has been set already, model is immutable");
        }
        this.service = service;
    }

    @Override
    public List<ValidationError> validate() {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (this.getName() == null || this.getName().isEmpty()) {
            errors.add(new ValidationError(this.getClass(), "name", "StateVariable without name of: " + String.valueOf(this.getService())));
        } else if (!ModelUtil.isValidUDAName(this.getName())) {
            SpecificationViolationReporter.report(((Service)this.getService()).getDevice(), "Invalid state variable name: {}", new Object[]{this});
        }
        errors.addAll(this.getTypeDetails().validate());
        return errors;
    }

    public boolean isModeratedNumericType() {
        return Datatype.Builtin.isNumeric(this.getTypeDetails().getDatatype().getBuiltin()) && this.getEventDetails().getEventMinimumDelta() > 0;
    }

    public StateVariable<S> deepCopy() {
        return new StateVariable<S>(this.getName(), this.getTypeDetails(), this.getEventDetails());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(").append(this.getClass().getSimpleName());
        sb.append(", Name: ").append(this.getName());
        sb.append(", Type: ").append(this.getTypeDetails().getDatatype().getDisplayString()).append(")");
        if (!this.getEventDetails().isSendEvents()) {
            sb.append(" (No Events)");
        }
        if (this.getTypeDetails().getDefaultValue() != null) {
            sb.append(" Default Value: ").append("'").append(this.getTypeDetails().getDefaultValue()).append("'");
        }
        if (this.getTypeDetails().getAllowedValues() != null) {
            sb.append(" Allowed Values: ");
            String[] stringArray = this.getTypeDetails().getAllowedValues();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                sb.append(s).append("|");
                ++n2;
            }
        }
        return sb.toString();
    }
}

