/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.observability;

import com.mongodb.RequestContext;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;

class MapRequestContext
implements RequestContext {
    private final Map<Object, Object> map;

    public MapRequestContext() {
        this(new HashMap<Object, Object>());
    }

    public MapRequestContext(Map<Object, Object> context) {
        this.map = context;
    }

    public <T> T get(Object key) {
        return (T)this.map.get(key);
    }

    public boolean hasKey(Object key) {
        return this.map.containsKey(key);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public void put(Object key, Object value) {
        this.map.put(key, value);
    }

    public void delete(Object key) {
        this.map.remove(key);
    }

    public int size() {
        return this.map.size();
    }

    public Stream<Map.Entry<Object, Object>> stream() {
        return this.map.entrySet().stream();
    }
}

