/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics;

import io.jenetics.Gene;
import io.jenetics.MultiPointCrossover;
import io.jenetics.internal.util.Equality;
import io.jenetics.internal.util.Hash;
import io.jenetics.util.MSeq;
import io.jenetics.util.RandomRegistry;
import java.util.Random;

public class SinglePointCrossover<G extends Gene<?, G>, C extends Comparable<? super C>>
extends MultiPointCrossover<G, C> {
    public SinglePointCrossover(double probability2) {
        super(probability2, 1);
    }

    public SinglePointCrossover() {
        this(0.05);
    }

    @Override
    protected int crossover(MSeq<G> that, MSeq<G> other) {
        Random random2 = RandomRegistry.getRandom();
        int index = random2.nextInt(Math.min(that.length(), other.length()));
        SinglePointCrossover.crossover(that, other, index);
        return 2;
    }

    static <T> void crossover(MSeq<T> that, MSeq<T> other, int index) {
        assert (index >= 0) : String.format("Crossover index must be within [0, %d) but was %d", that.length(), index);
        that.swap(index, Math.min(that.length(), other.length()), other, index);
    }

    @Override
    public int hashCode() {
        return Hash.of(this.getClass()).and(super.hashCode()).value();
    }

    @Override
    public boolean equals(Object obj) {
        return Equality.of(this, obj).test(x$0 -> super.equals(x$0));
    }

    @Override
    public String toString() {
        return String.format("%s[p=%f]", this.getClass().getSimpleName(), this._probability);
    }
}

