/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.internal.collection;

import io.jenetics.internal.collection.Array;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;

public final class CharStore
implements Array.Store<Character>,
Serializable {
    private static final long serialVersionUID = 1L;
    public final char[] array;

    private CharStore(char[] chars) {
        this.array = Objects.requireNonNull(chars);
    }

    public CharStore(int length) {
        this(new char[length]);
    }

    @Override
    public Character get(int index) {
        return Character.valueOf(this.array[index]);
    }

    @Override
    public void sort(int from, int until, Comparator<? super Character> comparator) {
        if (comparator == null) {
            Arrays.sort(this.array, from, until);
        } else {
            int i;
            Character[] chars = new Character[this.array.length];
            for (i = 0; i < this.array.length; ++i) {
                chars[i] = Character.valueOf(this.array[i]);
            }
            Arrays.sort(chars, from, until, comparator);
            for (i = 0; i < this.array.length; ++i) {
                this.array[i] = chars[i].charValue();
            }
        }
    }

    @Override
    public void set(int index, Character value) {
        this.array[index] = value.charValue();
    }

    public CharStore copy(int from, int until) {
        char[] array2 = new char[until - from];
        System.arraycopy(this.array, from, array2, 0, until - from);
        return new CharStore(array2);
    }

    public CharStore newInstance(int length) {
        return new CharStore(length);
    }

    @Override
    public int length() {
        return this.array.length;
    }

    public static CharStore of(char[] chars) {
        return new CharStore(chars);
    }
}

