/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.service.analytics.api.devicereport.switches;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.ubnt.data.X;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class PortSettings {
    private Boolean macWhiteListEnabled;
    private Boolean poeEnabled;
    private String operateMode;
    private String dot1xMode;
    private Boolean linkspeedAuto;
    private Boolean fullDuplex;
    private Integer linkSpeed;
    private Boolean isolationEnabled;
    private Boolean stormControlEnabled;
    private Boolean lldpMedEnabled;
    private Boolean lldpMedTopologyChangedNotifyEnabled;
    private Boolean stpEnabled;
    private Boolean egressRateLimitEnabled;
    private Boolean voiceVlanEnabled;
    private Long vlanParticipated;
    private String forward;

    public PortSettings(X x2) {
        this.macWhiteListEnabled = x2.is("port_security_enabled", false);
        this.poeEnabled = x2.getString("poe_mode", "auto").equals("auto");
        this.operateMode = x2.getString("op_mode", "switch");
        this.dot1xMode = x2.getString("dot1x_ctrl", "force_auth");
        this.linkspeedAuto = x2.is("autoneg", true);
        this.isolationEnabled = x2.is("isolation", false);
        this.stormControlEnabled = x2.is("stormctrl_ucast_enabled", false) || x2.is("stormctrl_mcast_enabled", false) || x2.is("stormctrl_bcast_enabled", false);
        this.lldpMedEnabled = x2.is("lldpmed_enabled", true);
        this.lldpMedTopologyChangedNotifyEnabled = x2.is("lldpmed_notify_enabled", false);
        this.stpEnabled = x2.is("stp_port_mode", true);
        this.egressRateLimitEnabled = x2.is("egress_rate_limit_kbps_enabled", false);
        this.voiceVlanEnabled = x2.getNonEmptyString("voice_networkconf_id") != null;
        this.fullDuplex = x2.is("full_duplex", true);
        this.linkSpeed = x2.getInt("speed");
        this.forward = x2.getString("forward");
    }

    public Boolean getMacWhiteListEnabled() {
        return this.macWhiteListEnabled;
    }

    public Boolean getPoeEnabled() {
        return this.poeEnabled;
    }

    public String getOperateMode() {
        return this.operateMode;
    }

    public String getDot1xMode() {
        return this.dot1xMode;
    }

    public Boolean getLinkspeedAuto() {
        return this.linkspeedAuto;
    }

    public Boolean getIsolationEnabled() {
        return this.isolationEnabled;
    }

    public Boolean getStormControlEnabled() {
        return this.stormControlEnabled;
    }

    public Boolean getLldpMedEnabled() {
        return this.lldpMedEnabled;
    }

    public Boolean getLldpMedTopologyChangedNotifyEnabled() {
        return this.lldpMedTopologyChangedNotifyEnabled;
    }

    public Boolean getStpEnabled() {
        return this.stpEnabled;
    }

    public Boolean getEgressRateLimitEnabled() {
        return this.egressRateLimitEnabled;
    }

    public Boolean getVoiceVlanEnabled() {
        return this.voiceVlanEnabled;
    }

    public Long getVlanParticipated() {
        return this.vlanParticipated;
    }

    public PortSettings setVlanParticipated(long l2) {
        this.vlanParticipated = l2;
        return this;
    }

    public Boolean getFullDuplex() {
        return this.fullDuplex;
    }

    public Integer getLinkSpeed() {
        return this.linkSpeed;
    }

    public String getForward() {
        return this.forward;
    }
}

