/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.component;

import java.net.URI;
import org.verapdf.ReleaseDetails;
import org.verapdf.component.AuditDuration;
import org.verapdf.component.AuditDurationImpl;
import org.verapdf.component.ComponentDetails;
import org.verapdf.component.ComponentDetailsImpl;

public final class Components {
    private Components() {
    }

    public static ComponentDetails defaultDetails() {
        return ComponentDetailsImpl.defaultInstance();
    }

    public static ComponentDetails libraryDetails(URI id, String name) {
        return Components.veraDetails(id, name, ReleaseDetails.getInstance().getVersion(), "Core veraPDF library component.");
    }

    public static ComponentDetails veraDetails(URI id, String name, String version, String description) {
        return Components.detailsFromValues(id, name, version, "The veraPDF Consortium.", description);
    }

    public static ComponentDetails detailsFromValues(URI id, String name, String version, String provider, String description) {
        if (id == null) {
            throw new NullPointerException(Components.nullMessage("id"));
        }
        if (name == null) {
            throw new NullPointerException(Components.nullMessage("name"));
        }
        if (version == null) {
            throw new NullPointerException(Components.nullMessage("version"));
        }
        if (provider == null) {
            throw new NullPointerException(Components.nullMessage("provider"));
        }
        if (description == null) {
            throw new NullPointerException(Components.nullMessage("description"));
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException(Components.emptyMessage("name"));
        }
        if (version.isEmpty()) {
            throw new IllegalArgumentException(Components.emptyMessage("version"));
        }
        if (provider.isEmpty()) {
            throw new IllegalArgumentException(Components.emptyMessage("provider"));
        }
        if (description.isEmpty()) {
            throw new IllegalArgumentException(Components.emptyMessage("description"));
        }
        return ComponentDetailsImpl.fromValues(id, name, version, provider, description);
    }

    public static AuditDuration defaultDuration() {
        return AuditDurationImpl.defaultInstance();
    }

    private static String nullMessage(String name) {
        return Components.makeMessage(name, "null");
    }

    private static String emptyMessage(String name) {
        return Components.makeMessage(name, "empty");
    }

    private static String makeMessage(String name, String suffix) {
        return "Argument " + name + " can not be " + suffix + ".";
    }

    public static class Timer {
        private final long start = System.currentTimeMillis();

        private Timer() {
        }

        public AuditDuration stop() {
            return AuditDurationImpl.fromValues(this.start, System.currentTimeMillis());
        }

        public static Timer start() {
            return new Timer();
        }
    }
}

