/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.domain;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.ArchUnitException;
import com.tngtech.archunit.base.MayResolveTypesViaReflection;
import com.tngtech.archunit.base.ResolvesTypesViaReflection;
import com.tngtech.archunit.base.Suppliers;
import com.tngtech.archunit.core.domain.Formatters;
import com.tngtech.archunit.core.domain.JavaAnnotation;
import com.tngtech.archunit.core.domain.JavaCodeUnit;
import com.tngtech.archunit.core.domain.JavaCodeUnitAccess;
import com.tngtech.archunit.core.domain.JavaConstructorCall;
import com.tngtech.archunit.core.domain.JavaConstructorReference;
import com.tngtech.archunit.core.domain.JavaTypeVariable;
import com.tngtech.archunit.core.domain.ThrowsClause;
import com.tngtech.archunit.core.domain.properties.HasName;
import com.tngtech.archunit.core.importer.DomainBuilders;
import com.tngtech.archunit.thirdparty.com.google.common.collect.Sets;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;

@PublicAPI(usage=PublicAPI.Usage.ACCESS)
public final class JavaConstructor
extends JavaCodeUnit {
    private final Supplier<Constructor<?>> constructorSupplier;
    private final ThrowsClause<JavaConstructor> throwsClause;
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static final String CONSTRUCTOR_NAME = "<init>";

    JavaConstructor(DomainBuilders.JavaConstructorBuilder builder) {
        super(builder);
        this.throwsClause = builder.getThrowsClause(this);
        this.constructorSupplier = Suppliers.memoize(new ReflectConstructorSupplier());
    }

    @Override
    public List<JavaTypeVariable<JavaConstructor>> getTypeParameters() {
        return super.getTypeParameters();
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public ThrowsClause<JavaConstructor> getThrowsClause() {
        return this.throwsClause;
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isConstructor() {
        return true;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaConstructorCall> getCallsOfSelf() {
        return this.getReverseDependencies().getCallsTo(this);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaConstructorReference> getReferencesToSelf() {
        return this.getReverseDependencies().getReferencesTo(this);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public Set<JavaCodeUnitAccess<?>> getAccessesToSelf() {
        return Sets.union(this.getCallsOfSelf(), this.getReferencesToSelf());
    }

    @Override
    public Set<JavaAnnotation<JavaConstructor>> getAnnotations() {
        return super.getAnnotations();
    }

    @Override
    public JavaAnnotation<JavaConstructor> getAnnotationOfType(String typeName) {
        return super.getAnnotationOfType(typeName);
    }

    @Override
    public Optional<JavaAnnotation<JavaConstructor>> tryGetAnnotationOfType(String typeName) {
        return super.tryGetAnnotationOfType(typeName);
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    @ResolvesTypesViaReflection
    @MayResolveTypesViaReflection(reason="This is not part of the import and a specific decision to rely on the classpath")
    public Constructor<?> reflect() {
        return this.constructorSupplier.get();
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public String getDescription() {
        return "Constructor <" + this.getFullName() + ">";
    }

    @ResolvesTypesViaReflection
    @MayResolveTypesViaReflection(reason="Just part of a bigger resolution process")
    private class ReflectConstructorSupplier
    implements Supplier<Constructor<?>> {
        private ReflectConstructorSupplier() {
        }

        @Override
        public Constructor<?> get() {
            Class<?> reflectedOwner = JavaConstructor.this.getOwner().reflect();
            try {
                return reflectedOwner.getDeclaredConstructor(JavaCodeUnit.reflect(JavaConstructor.this.getRawParameterTypes()));
            }
            catch (NoSuchMethodException e) {
                throw new ArchUnitException.InconsistentClassPathException("Can't resolve constructor " + Formatters.formatMethod(reflectedOwner.getName(), JavaConstructor.this.getName(), HasName.Utils.namesOf(JavaConstructor.this.getRawParameterTypes())), e);
            }
        }
    }
}

