/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.util.LittleEndianDataConverter;
import ghidra.util.exception.AssertException;
import java.math.BigInteger;
import java.nio.ByteBuffer;

public class Numeric {
    private int subTypeIndex;
    private Object object;

    public Numeric(PdbByteReader reader) throws PdbException {
        this.parse(reader);
    }

    public int getSubTypeIndex() {
        return this.subTypeIndex;
    }

    public Object getNumericObject() {
        return this.object;
    }

    public boolean isIntegral() {
        return this.object instanceof BigInteger;
    }

    public boolean isSigned() {
        switch (this.subTypeIndex) {
            case 32768: 
            case 32769: 
            case 32771: 
            case 32777: 
            case 32791: {
                return true;
            }
        }
        return false;
    }

    public int getSize() {
        switch (this.subTypeIndex) {
            case 32768: {
                return 1;
            }
            case 32769: 
            case 32770: {
                return 2;
            }
            case 32771: 
            case 32772: 
            case 32773: {
                return 4;
            }
            case 32774: {
                return 8;
            }
            case 32775: {
                return 10;
            }
            case 32776: {
                return 16;
            }
            case 32777: 
            case 32778: {
                return 8;
            }
            case 32779: {
                return 6;
            }
            case 32780: {
                return 8;
            }
            case 32781: {
                return 16;
            }
            case 32782: {
                return 20;
            }
            case 32783: {
                return 32;
            }
            case 32791: {
                return 16;
            }
            case 32792: {
                return 16;
            }
            case 32793: {
                return 16;
            }
            case 32794: {
                return 8;
            }
            case 32795: {
                return 2;
            }
        }
        return 0;
    }

    public BigInteger getIntegral() {
        if (!(this.object instanceof BigInteger)) {
            throw new AssertException("Numeric is not an integral type");
        }
        return (BigInteger)this.object;
    }

    public String toString() {
        return this.object.toString();
    }

    public void parse(PdbByteReader reader) throws PdbException {
        this.subTypeIndex = reader.parseUnsignedShortVal();
        switch (this.subTypeIndex) {
            case 32768: {
                this.object = LittleEndianDataConverter.INSTANCE.getBigInteger(reader.parseBytes(1), 1, true);
                break;
            }
            case 32769: {
                this.object = LittleEndianDataConverter.INSTANCE.getBigInteger(reader.parseBytes(2), 2, true);
                break;
            }
            case 32770: {
                this.object = LittleEndianDataConverter.INSTANCE.getBigInteger(reader.parseBytes(2), 2, false);
                break;
            }
            case 32771: {
                this.object = LittleEndianDataConverter.INSTANCE.getBigInteger(reader.parseBytes(4), 4, true);
                break;
            }
            case 32772: {
                this.object = LittleEndianDataConverter.INSTANCE.getBigInteger(reader.parseBytes(4), 4, false);
                break;
            }
            case 32773: {
                this.object = Float.valueOf(ByteBuffer.wrap(reader.parseBytes(4)).getFloat());
                break;
            }
            case 32774: {
                this.object = ByteBuffer.wrap(reader.parseBytes(8)).getDouble();
                break;
            }
            case 32775: {
                this.object = new Real80(this, reader);
                break;
            }
            case 32776: {
                this.object = new Real128(this, reader);
                break;
            }
            case 32777: {
                this.object = LittleEndianDataConverter.INSTANCE.getBigInteger(reader.parseBytes(8), 8, true);
                break;
            }
            case 32778: {
                this.object = LittleEndianDataConverter.INSTANCE.getBigInteger(reader.parseBytes(8), 8, false);
                break;
            }
            case 32779: {
                this.object = new Real48(this, reader);
                break;
            }
            case 32780: {
                this.object = new Complex32(this, reader);
                break;
            }
            case 32781: {
                this.object = new Complex64(this, reader);
                break;
            }
            case 32782: {
                this.object = new Complex80(this, reader);
                break;
            }
            case 32783: {
                this.object = new Complex128(this, reader);
                break;
            }
            case 32791: {
                this.object = LittleEndianDataConverter.INSTANCE.getBigInteger(reader.parseBytes(16), 16, true);
                break;
            }
            case 32792: {
                this.object = LittleEndianDataConverter.INSTANCE.getBigInteger(reader.parseBytes(16), 16, false);
                break;
            }
            case 32793: {
                this.object = new Decimal(this, reader);
                break;
            }
            case 32794: {
                this.object = new Date(this, reader);
                break;
            }
            case 32795: {
                this.object = new Real16(this, reader);
                break;
            }
            default: {
                if (this.subTypeIndex >= 32768) {
                    throw new PdbException(String.format("Unknown Numeric subtype: 0x%04x", this.subTypeIndex));
                }
                this.object = BigInteger.valueOf(this.subTypeIndex);
            }
        }
    }

    private class Real80
    extends AbstractNumericOther {
        private Real80(Numeric numeric, PdbByteReader reader) throws PdbException {
            super(numeric, reader, 10);
        }
    }

    private class Real128
    extends AbstractNumericOther {
        private Real128(Numeric numeric, PdbByteReader reader) throws PdbException {
            super(numeric, reader, 16);
        }
    }

    private class Real48
    extends AbstractNumericOther {
        private Real48(Numeric numeric, PdbByteReader reader) throws PdbException {
            super(numeric, reader, 6);
        }
    }

    private class Complex32
    extends AbstractNumericOther {
        private Complex32(Numeric numeric, PdbByteReader reader) throws PdbException {
            super(numeric, reader, 8);
        }
    }

    private class Complex64
    extends AbstractNumericOther {
        private Complex64(Numeric numeric, PdbByteReader reader) throws PdbException {
            super(numeric, reader, 16);
        }
    }

    private class Complex80
    extends AbstractNumericOther {
        private Complex80(Numeric numeric, PdbByteReader reader) throws PdbException {
            super(numeric, reader, 20);
        }
    }

    private class Complex128
    extends AbstractNumericOther {
        private Complex128(Numeric numeric, PdbByteReader reader) throws PdbException {
            super(numeric, reader, 32);
        }
    }

    private class Decimal
    extends AbstractNumericOther {
        Decimal(Numeric numeric, PdbByteReader reader) throws PdbException {
            super(numeric, reader, 16);
        }
    }

    private class Date
    extends AbstractNumericOther {
        Date(Numeric numeric, PdbByteReader reader) throws PdbException {
            super(numeric, reader, 8);
        }
    }

    private class Real16
    extends AbstractNumericOther {
        private Real16(Numeric numeric, PdbByteReader reader) throws PdbException {
            super(numeric, reader, 2);
        }
    }

    private abstract class AbstractNumericOther {
        private byte[] bytes;

        AbstractNumericOther(Numeric numeric, PdbByteReader reader, int num) throws PdbException {
            this.parse(reader, num);
        }

        private void parse(PdbByteReader reader, int num) throws PdbException {
            this.bytes = reader.parseBytes(num);
        }

        private byte[] getBytes() {
            return this.bytes;
        }
    }
}

