/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.symbol;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractParsableItem;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import java.util.HashMap;
import java.util.Map;

public class InstructionAnnotation
extends AbstractParsableItem {
    private Opcode instructionCode;
    private long parameter1;
    private long parameter2;

    public InstructionAnnotation(PdbByteReader reader) throws PdbException {
        this.instructionCode = Opcode.fromValue(this.decompressData(reader));
        if (this.instructionCode == Opcode.INVALID) {
            reader.align4();
        } else if (this.instructionCode == Opcode.CHANGE_CODE_LENGTH_AND_CODE_OFFSET) {
            this.parameter1 = this.decompressData(reader);
            this.parameter2 = this.decompressData(reader);
        } else if (this.instructionCode == Opcode.CHANGE_LINE_OFFSET || this.instructionCode == Opcode.CHANGE_COLUMN_END_DELTA) {
            this.parameter1 = this.decodeSignedInt32(this.decompressData(reader));
            this.parameter2 = -1L;
        } else {
            this.parameter1 = this.decompressData(reader);
            this.parameter2 = -1L;
        }
    }

    public Opcode getInstructionCode() {
        return this.instructionCode;
    }

    @Override
    public void emit(StringBuilder builder) {
        if (this.instructionCode == Opcode.CHANGE_CODE_LENGTH_AND_CODE_OFFSET) {
            builder.append("  " + String.valueOf((Object)this.instructionCode) + String.format(" %x %x", this.parameter1, this.parameter2));
        } else if (this.instructionCode == Opcode.CHANGE_CODE_OFFSET_AND_LINE_OFFSET) {
            builder.append("  " + String.valueOf((Object)this.instructionCode) + String.format(" %x %x", this.parameter1 >> 4 & 0xFFFFFFFL, this.parameter1 & 0xFL));
        } else {
            builder.append("  " + String.valueOf((Object)this.instructionCode) + String.format(" %x", (int)this.parameter1));
        }
    }

    private int decompressData(PdbByteReader reader) throws PdbException {
        int result = Integer.MIN_VALUE;
        int val = reader.parseUnsignedByteVal();
        if (val < 128) {
            result = val;
        } else if ((val & 0xC0) == 128) {
            result = (val & 0x3F) << 8;
            result |= reader.parseUnsignedByteVal();
        } else if ((val & 0xE0) == 192) {
            result = (val & 0x1F) << 24;
            result |= reader.parseUnsignedByteVal() << 16;
            result |= reader.parseUnsignedByteVal() << 8;
            result |= reader.parseUnsignedByteVal();
        }
        return result;
    }

    private int decodeSignedInt32(int input) {
        if ((input & 1) == 1) {
            return -(input >> 1);
        }
        return input >> 1;
    }

    public static enum Opcode {
        INVALID("Illegal", 0),
        CODE_OFFSET("Offset", 1),
        CHANGE_CODE_OFFSET_BASE("CodeOffsetBase", 2),
        CHANGE_CODE_OFFSET("CodeOffset", 3),
        CHANGE_CODE_LENGTH("CodeLength", 4),
        CHANGE_FILE("File", 5),
        CHANGE_LINE_OFFSET("LineOffset", 6),
        CHANGE_LINE_END_DELTA("LineEndDelta", 7),
        CHANGE_RANGE_KIND("RangeKind", 8),
        CHANGE_COLUMN_START("ColumnStart", 9),
        CHANGE_COLUMN_END_DELTA("ColumnEndDelta", 10),
        CHANGE_CODE_OFFSET_AND_LINE_OFFSET("CodeOffsetAndLineOffset", 11),
        CHANGE_CODE_LENGTH_AND_CODE_OFFSET("CodeLengthAndCodeOffset", 12),
        CHANGE_COLUMN_END("ColumnEnd", 13);

        private static final Map<Integer, Opcode> BY_VALUE;
        public final String label;
        public final int value;

        public String toString() {
            return this.label;
        }

        public static Opcode fromValue(int val) {
            return BY_VALUE.getOrDefault(val, INVALID);
        }

        private Opcode(String label, int value) {
            this.label = label;
            this.value = value;
        }

        static {
            BY_VALUE = new HashMap<Integer, Opcode>();
            for (Opcode val : Opcode.values()) {
                BY_VALUE.put(val.value, val);
            }
        }
    }
}

