/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.cmd.function.ApplyFunctionSignatureCmd;
import ghidra.app.cmd.function.CallDepthChangeInfo;
import ghidra.app.util.SymbolPath;
import ghidra.app.util.bin.format.pdb2.pdbreader.MsSymbolIterator;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractProcedureMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractProcedureStartIa64MsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractProcedureStartMipsMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractProcedureStartMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractThunkMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMemberFunctionMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractPointerMsType;
import ghidra.app.util.pdb.pdbapplicator.AbstractBlockContextApplier;
import ghidra.app.util.pdb.pdbapplicator.AbstractComplexTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.AbstractFunctionTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.BlockNestingSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.DefaultPdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.DisassembleableAddressSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.MsTypeApplier;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionSignature;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.InstructionIterator;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.InvalidNameException;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.util.List;

public class FunctionSymbolApplier
extends AbstractBlockContextApplier
implements BlockNestingSymbolApplier,
DisassembleableAddressSymbolApplier {
    private Function function = null;
    private long specifiedFrameSize_x = 0L;
    private long currentFrameSize_x = 0L;
    private int baseParamOffset = 0;
    private AbstractBlockContextApplier.RegisterChangeCalculator registerChangeCalculator;
    private AbstractProcedureMsSymbol symbol;

    public FunctionSymbolApplier(DefaultPdbApplicator applicator, AbstractProcedureMsSymbol symbol) {
        super(applicator);
        this.symbol = symbol;
    }

    @Override
    public void apply(MsSymbolIterator iter) throws PdbException, CancelledException {
        this.getValidatedSymbol(iter, true);
        this.processSymbol(iter);
    }

    @Override
    public Address getAddressForDisassembly() {
        return this.applicator.getAddress(this.symbol);
    }

    private void processSymbol(MsSymbolIterator iter) throws CancelledException, PdbException {
        Address address = this.applicator.getAddress(this.symbol);
        String name = this.symbol.getName();
        if (!this.processEndSymbol(this.symbol.getEndPointer(), iter)) {
            this.applicator.appendLogMsg("PDB: Failed to process function at address " + String.valueOf(address));
            return;
        }
        if (this.applicator.isInvalidAddress(address, name)) {
            this.applicator.appendLogMsg("PDB: Failed to process function at address: " + String.valueOf(address));
            return;
        }
        this.function = this.applicator.getExistingOrCreateOneByteFunction(address);
        if (this.function == null) {
            return;
        }
        boolean succeededSetFunctionSignature = this.setFunctionDefinition(this.function, address);
        this.applicator.createSymbol(address, this.getReconciledSymbolPath(), succeededSetFunctionSignature);
    }

    private SymbolPath getReconciledSymbolPath() {
        AbstractPointerMsType ptr;
        RecordNumber rpt;
        String name = this.symbol.getName();
        SymbolPath symbolPath = new SymbolPath(name);
        RecordNumber typeRecordNumber = this.symbol.getTypeRecordNumber();
        AbstractMsType fType = this.applicator.getTypeRecord(typeRecordNumber);
        if (!(fType instanceof AbstractMemberFunctionMsType)) {
            return symbolPath;
        }
        AbstractMemberFunctionMsType memberFunction = (AbstractMemberFunctionMsType)fType;
        RecordNumber rc = memberFunction.getContainingClassRecordNumber();
        SymbolPath containerSymbolPath = AbstractComplexTypeApplier.getSymbolPath(this.applicator, rc);
        this.applicator.predefineClass(containerSymbolPath);
        AbstractMsType p = memberFunction.getThisPointerType();
        if (p instanceof AbstractPointerMsType && !(rpt = (ptr = (AbstractPointerMsType)p).getUnderlyingRecordNumber()).equals(rc)) {
            SymbolPath underlyingSymbolPath = AbstractComplexTypeApplier.getSymbolPath(this.applicator, rc);
            this.applicator.predefineClass(underlyingSymbolPath);
        }
        if (!name.startsWith("`anonymous namespace'") && !name.startsWith("anonymous-namespace")) {
            return symbolPath;
        }
        List containerParts = containerSymbolPath.asList();
        List parts = symbolPath.asList();
        if (containerParts.size() != parts.size() - 1) {
            Msg.info((Object)this, (Object)"Unmatched symbol path size during fn name reconcilation");
            return symbolPath;
        }
        for (int i = 0; i < containerParts.size(); ++i) {
            String part;
            String containerPart = (String)containerParts.get(i);
            if (containerPart.equals(part = (String)parts.get(i))) continue;
            if (i == 0) {
                parts.set(i, containerPart);
                continue;
            }
            Msg.info((Object)this, (Object)"Mismatch symbol path nodes during fn name reconcilation");
            return symbolPath;
        }
        return new SymbolPath(parts);
    }

    private boolean setFunctionDefinition(Function function, Address address) throws CancelledException, PdbException {
        RecordNumber typeRecordNumber = this.symbol.getTypeRecordNumber();
        if (typeRecordNumber == RecordNumber.NO_TYPE) {
            return false;
        }
        if (function.getSignatureSource().isHigherPriorityThan(SourceType.ANALYSIS)) {
            return false;
        }
        function.setThunkedFunction(null);
        function.setNoReturn(this.isNonReturning());
        AbstractMsType fType = this.applicator.getTypeRecord(typeRecordNumber);
        MsTypeApplier applier = this.applicator.getTypeApplier(fType);
        if (!(applier instanceof AbstractFunctionTypeApplier)) {
            this.applicator.appendLogMsg("Error: Failed to resolve datatype RecordNumber " + String.valueOf(typeRecordNumber) + " at " + String.valueOf(address));
            return false;
        }
        DataType dataType = this.applicator.getCompletedDataType(typeRecordNumber);
        if (!(dataType instanceof FunctionDefinition)) {
            return false;
        }
        FunctionDefinition def = (FunctionDefinition)dataType.copy(this.applicator.getDataTypeManager());
        try {
            def.setName(function.getName());
        }
        catch (InvalidNameException | DuplicateNameException e) {
            throw new RuntimeException("unexpected exception", e);
        }
        ApplyFunctionSignatureCmd sigCmd = new ApplyFunctionSignatureCmd(address, (FunctionSignature)def, SourceType.IMPORTED);
        TaskMonitor monitor = this.applicator.getCancelOnlyWrappingMonitor();
        if (!sigCmd.applyTo(this.applicator.getProgram(), monitor)) {
            this.applicator.appendLogMsg("PDB Warning: Failed to apply signature to function at address " + String.valueOf(address) + " due to " + sigCmd.getStatusMsg() + "; dataType: " + def.getName());
            return false;
        }
        return true;
    }

    @Override
    public void deferredApply(MsSymbolIterator iter) throws PdbException, CancelledException {
        this.getValidatedSymbol(iter, true);
        String name = this.symbol.getName();
        Address address = this.applicator.getAddress(this.symbol);
        Long functionLength = this.symbol.getProcedureLength();
        this.applicator.setFunctionLength(address, functionLength.intValue());
        this.function = this.applicator.getExistingFunction(address);
        if (this.function == null) {
            if (!this.processEndSymbol(this.symbol.getEndPointer(), iter)) {
                this.applicator.appendLogMsg("PDB: Failed to process function at address " + String.valueOf(address));
            }
            return;
        }
        long start = this.getStartOffset();
        long end = this.getEndOffset();
        Address blockAddress = address.add(start);
        long length = end - start;
        this.deferredProcessing(iter, name, address, blockAddress, length);
    }

    Function getFunction() {
        return this.function;
    }

    long getCurrentFrameSize() {
        return this.currentFrameSize_x;
    }

    long getSpecifiedFrameSize() {
        return this.specifiedFrameSize_x;
    }

    @Override
    void setSpecifiedFrameSize(long specifiedFrameSize) {
        this.specifiedFrameSize_x = specifiedFrameSize;
        this.currentFrameSize_x = specifiedFrameSize;
    }

    String getName() {
        return this.symbol.getName();
    }

    Integer getRegisterPrologChange(Register register) {
        return this.registerChangeCalculator.getRegChange(this.applicator, register);
    }

    int getBaseParamOffset() {
        return this.baseParamOffset;
    }

    void setLocalVariable(Address varAddress, String varName, DataType dataType) {
        if (varAddress == null) {
            return;
        }
        if (varName.isBlank()) {
            return;
        }
        String plateAddition = "PDB: static local for function (" + String.valueOf(this.applicator.getAddress(this.symbol)) + "): " + this.getName();
        this.applicator.createSymbol(varAddress, varName, false, plateAddition);
    }

    private int getFrameBaseOffset(TaskMonitor monitor) throws CancelledException {
        int retAddrSize = this.function.getProgram().getDefaultPointerSize();
        if (retAddrSize != 8) {
            return -retAddrSize;
        }
        Register frameReg = this.function.getProgram().getCompilerSpec().getStackPointer();
        Address entryAddr = this.function.getEntryPoint();
        AddressSet scopeSet = new AddressSet();
        scopeSet.addRange(entryAddr, entryAddr.add(64L));
        CallDepthChangeInfo valueChange = new CallDepthChangeInfo(this.function, (AddressSetView)scopeSet, frameReg, monitor);
        InstructionIterator instructions = this.function.getProgram().getListing().getInstructions((AddressSetView)scopeSet, true);
        int max = 0;
        while (instructions.hasNext()) {
            monitor.checkCancelled();
            Instruction next = instructions.next();
            int newValue = valueChange.getDepth(next.getMinAddress());
            if (newValue < -20480 || newValue > 20480 || Math.abs(newValue) <= Math.abs(max)) continue;
            max = newValue;
        }
        return max;
    }

    @Override
    long getStartOffset() {
        return this.symbol.getDebugStartOffset();
    }

    @Override
    long getEndOffset() {
        return this.symbol.getDebugEndOffset();
    }

    private boolean isNonReturning() {
        AbstractProcedureMsSymbol abstractProcedureMsSymbol = this.symbol;
        if (abstractProcedureMsSymbol instanceof AbstractProcedureStartMsSymbol) {
            AbstractProcedureStartMsSymbol procMs = (AbstractProcedureStartMsSymbol)abstractProcedureMsSymbol;
            return procMs.getFlags().doesNotReturn();
        }
        abstractProcedureMsSymbol = this.symbol;
        if (abstractProcedureMsSymbol instanceof AbstractProcedureStartIa64MsSymbol) {
            AbstractProcedureStartIa64MsSymbol procIa64 = (AbstractProcedureStartIa64MsSymbol)abstractProcedureMsSymbol;
            return procIa64.getFlags().doesNotReturn();
        }
        abstractProcedureMsSymbol = this.symbol;
        if (abstractProcedureMsSymbol instanceof AbstractProcedureStartMipsMsSymbol) {
            AbstractProcedureStartMipsMsSymbol procMips = (AbstractProcedureStartMipsMsSymbol)abstractProcedureMsSymbol;
            return false;
        }
        abstractProcedureMsSymbol = this.symbol;
        if (abstractProcedureMsSymbol instanceof AbstractThunkMsSymbol) {
            AbstractThunkMsSymbol procThunk = (AbstractThunkMsSymbol)abstractProcedureMsSymbol;
            return false;
        }
        throw new AssertException("PDB: getNonReturning: Invalid symbol type: " + this.symbol.getClass().getSimpleName());
    }

    private AbstractProcedureMsSymbol getValidatedSymbol(MsSymbolIterator iter, boolean iterate) {
        AbstractMsSymbol abstractSymbol;
        AbstractMsSymbol abstractMsSymbol = abstractSymbol = iterate ? iter.next() : iter.peek();
        if (!(abstractSymbol instanceof AbstractProcedureMsSymbol)) {
            throw new AssertException("Invalid symbol type: " + abstractSymbol.getClass().getSimpleName());
        }
        AbstractProcedureMsSymbol procSymbol = (AbstractProcedureMsSymbol)abstractSymbol;
        return procSymbol;
    }
}

