/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.struct;

import ghidra.pcode.struct.AbstractStmt;
import ghidra.pcode.struct.LocalVar;
import ghidra.pcode.struct.StringTree;
import ghidra.pcode.struct.StructuredSleigh;
import ghidra.program.model.data.DataType;

class DeclStmt
extends AbstractStmt {
    private final String name;
    private final DataType type;

    protected DeclStmt(StructuredSleigh ctx, LocalVar decl) {
        super(ctx);
        this.name = decl.getName();
        this.type = decl.getType();
    }

    @Override
    protected StringTree generate(StructuredSleigh.Label next, StructuredSleigh.Label fall) {
        StringTree st = new StringTree();
        st.append("local ");
        st.append(this.name);
        st.append(":");
        st.append(Integer.toString(this.type.getLength()));
        st.append(";\n");
        st.append(next.genGoto(fall));
        return st;
    }
}

