/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.function;

import ghidra.framework.cmd.Command;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.exception.InvalidInputException;

public class SetReturnDataTypeCmd
implements Command<Program> {
    private Address entry;
    private DataType dataType;
    private String status;
    private SourceType source;

    public SetReturnDataTypeCmd(Address entry, DataType dataType, SourceType source) {
        this.entry = entry;
        this.dataType = dataType;
        this.source = source;
    }

    public String getName() {
        return "Set Return Data Type";
    }

    public boolean applyTo(Program program) {
        Function function = program.getListing().getFunctionAt(this.entry);
        try {
            function.setReturnType(this.dataType, this.source);
            if (this.source == SourceType.DEFAULT) {
                function.setSignatureSource(SourceType.DEFAULT);
            }
        }
        catch (InvalidInputException e) {
            this.status = e.getMessage();
            return false;
        }
        return true;
    }

    public String getStatusMsg() {
        return this.status;
    }
}

