/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.app.cmd.disassemble.DisassembleCommand;
import ghidra.app.cmd.function.ApplyFunctionSignatureCmd;
import ghidra.app.cmd.function.CreateFunctionCmd;
import ghidra.app.cmd.function.FunctionRenameOption;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.util.PseudoDisassembler;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.AbstractFloatDataType;
import ghidra.program.model.data.AbstractStringDataType;
import ghidra.program.model.data.CharDataType;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.data.ParameterDefinition;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.StringDataInstance;
import ghidra.program.model.data.TerminatedStringDataType;
import ghidra.program.model.data.TerminatedUnicodeDataType;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.data.VoidDataType;
import ghidra.program.model.data.WideCharDataType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.FunctionSignature;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.mem.MemoryBufferImpl;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.symbol.FlowType;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.program.util.ContextEvaluatorAdapter;
import ghidra.program.util.VarnodeContext;
import ghidra.util.task.TaskMonitor;

public class ConstantPropagationContextEvaluator
extends ContextEvaluatorAdapter {
    private static final int MAX_UNICODE_STRING_LEN = 200;
    private static final int MAX_CHAR_STRING__LEN = 100;
    protected AddressSet destSet = new AddressSet();
    private boolean trustMemoryWrite = false;
    private boolean createDataFromPointers = false;
    private long minStoreLoadOffset = 4L;
    private long minSpeculativeOffset = 1024L;
    private long maxSpeculativeOffset = 256L;
    protected TaskMonitor monitor;
    private final int NULL_TERMINATOR_PROBE = -1;

    public ConstantPropagationContextEvaluator(TaskMonitor monitor) {
        this.monitor = monitor;
    }

    public ConstantPropagationContextEvaluator(TaskMonitor monitor, boolean trustMemoryWrite) {
        this.monitor = monitor;
        this.trustMemoryWrite = trustMemoryWrite;
    }

    public ConstantPropagationContextEvaluator(TaskMonitor monitor, boolean trustWriteMemOption, long minStoreLoadRefAddress, long minSpeculativeRefAddress, long maxSpeculativeRefAddress) {
        this(monitor, trustWriteMemOption);
        this.minStoreLoadOffset = minStoreLoadRefAddress;
        this.minSpeculativeOffset = minSpeculativeRefAddress;
        this.maxSpeculativeOffset = maxSpeculativeRefAddress;
    }

    public ConstantPropagationContextEvaluator setTrustWritableMemory(boolean trustWriteableMemOption) {
        this.trustMemoryWrite = trustWriteableMemOption;
        return this;
    }

    public ConstantPropagationContextEvaluator setMinSpeculativeOffset(long minSpeculativeRefAddress) {
        this.minSpeculativeOffset = minSpeculativeRefAddress;
        return this;
    }

    public ConstantPropagationContextEvaluator setMaxSpeculativeOffset(long maxSpeculativeRefAddress) {
        this.maxSpeculativeOffset = maxSpeculativeRefAddress;
        return this;
    }

    public ConstantPropagationContextEvaluator setMinStoreLoadOffset(long minStoreLoadRefAddress) {
        this.maxSpeculativeOffset = minStoreLoadRefAddress;
        return this;
    }

    public ConstantPropagationContextEvaluator setCreateComplexDataFromPointers(boolean doCreateData) {
        this.createDataFromPointers = doCreateData;
        return this;
    }

    public AddressSet getDestinationSet() {
        return this.destSet;
    }

    @Override
    public Address evaluateConstant(VarnodeContext context, Instruction instr, int pcodeop, Address constant, int size, DataType dataType, RefType refType) {
        AddressSpace space = constant.getAddressSpace();
        long maxAddrOffset = space.getMaxAddress().getOffset();
        long wordOffset = constant.getOffset();
        if ((wordOffset >= 0L && wordOffset < this.minSpeculativeOffset || Math.abs(maxAddrOffset - wordOffset) < this.maxSpeculativeOffset) && !space.isExternalSpace()) {
            return null;
        }
        if (wordOffset == 0xFFFFFFFFL || wordOffset == 65535L || wordOffset == -1L) {
            return null;
        }
        return constant;
    }

    @Override
    public boolean evaluateReference(VarnodeContext context, Instruction instr, int pcodeop, Address address, int size, DataType dataType, RefType refType) {
        Data udata;
        boolean isKnownReference;
        if (refType.isCall() && !refType.isComputed() && pcodeop == 0) {
            return true;
        }
        AddressSpace space = address.getAddressSpace();
        if (space.isExternalSpace()) {
            return true;
        }
        long maxAddrOffset = space.getMaxAddress().getAddressableWordOffset();
        long wordOffset = address.getAddressableWordOffset();
        boolean bl = isKnownReference = !address.isConstantAddress();
        if (pcodeop != 1 && (wordOffset >= 0L && wordOffset < this.minStoreLoadOffset || Math.abs(maxAddrOffset - wordOffset) < this.minStoreLoadOffset)) {
            if (!isKnownReference) {
                return false;
            }
            PcodeOp[] pcode = instr.getPcode();
            if (pcode.length > 1) {
                return false;
            }
        }
        Program program = instr.getProgram();
        AutoAnalysisManager aMgr = AutoAnalysisManager.getAnalysisManager(program);
        if (refType.isData()) {
            this.createPointedToData(aMgr, program, address, refType, dataType, size);
        }
        Memory memory = program.getMemory();
        if (refType.isFlow() && !refType.isIndirect() && !memory.isExternalBlockAddress(address) && memory.getExecuteSet().contains(address) && (udata = program.getListing().getUndefinedDataAt(address)) != null) {
            DisassembleCommand cmd = new DisassembleCommand(address, null, true);
            cmd.applyTo(program, this.monitor);
        }
        return true;
    }

    private int createPointedToData(AutoAnalysisManager aMgr, Program program, Address address, RefType refType, DataType dataType, int size) {
        TypeDef typeDef;
        DataType dataType2;
        if (program.getMemory().isExternalBlockAddress(address) || address.isExternalAddress()) {
            return 0;
        }
        if (!program.getMemory().contains(address)) {
            return 0;
        }
        DataType pointedToDT = null;
        if (dataType instanceof Pointer) {
            Pointer ptr = (Pointer)dataType;
            pointedToDT = ptr.getDataType();
        } else if (dataType instanceof TypeDef && (dataType2 = (typeDef = (TypeDef)dataType).getBaseDataType()) instanceof Pointer) {
            Pointer ptr = (Pointer)dataType2;
            pointedToDT = ptr.getDataType();
        }
        if (pointedToDT instanceof FunctionDefinition) {
            FunctionDefinition funcDefn = (FunctionDefinition)pointedToDT;
            this.createFunctionApplySignature(aMgr, program, address, funcDefn);
            return dataType.getLength();
        }
        if (dataType != null) {
            // empty if block
        }
        return this.createData(program, address, pointedToDT, size);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int createData(Program program, Address address, DataType dataType, int size) {
        Data data = program.getListing().getDataAt(address);
        if (data == null || !Undefined.isUndefined((DataType)data.getDataType())) {
            return 0;
        }
        DataType dt = Undefined.getUndefinedDataType((int)size);
        int maxLen = -1;
        if (this.createDataFromPointers && dataType != null) {
            DataType originalDT = dataType;
            if (dataType instanceof TypeDef) {
                TypeDef typeDef = (TypeDef)dataType;
                dataType = typeDef.getBaseDataType();
            }
            if (dataType instanceof CharDataType) {
                maxLen = this.getRestrictedStringLen(program, address, (AbstractStringDataType)TerminatedStringDataType.dataType, 100);
                if (maxLen > 0) {
                    dt = TerminatedStringDataType.dataType;
                }
            } else if (dataType instanceof WideCharDataType) {
                maxLen = this.getRestrictedStringLen(program, address, (AbstractStringDataType)TerminatedUnicodeDataType.dataType, 200);
                if (maxLen > 0) {
                    dt = TerminatedUnicodeDataType.dataType;
                }
            } else if (dataType instanceof Composite) {
                Composite comp = (Composite)dataType;
                dt = originalDT;
            } else {
                if (dataType instanceof VoidDataType) {
                    return 0;
                }
                if (!(dataType instanceof AbstractFloatDataType)) return 0;
                dt = dataType;
            }
        } else if (size < 1 || size > 8) {
            return 0;
        }
        try {
            data = maxLen > 0 ? DataUtilities.createData((Program)program, (Address)address, (DataType)dt, (int)maxLen, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CLEAR_ALL_UNDEFINED_CONFLICT_DATA) : DataUtilities.createData((Program)program, (Address)address, (DataType)dt, (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CLEAR_ALL_UNDEFINED_CONFLICT_DATA);
            return data.getLength();
        }
        catch (CodeUnitInsertionException codeUnitInsertionException) {
            return 0;
        }
    }

    private void createFunctionApplySignature(AutoAnalysisManager aMgr, Program program, Address address, FunctionDefinition funcDefn) {
        Listing listing = program.getListing();
        Data data = listing.getDefinedDataContaining(address);
        if (data != null) {
            return;
        }
        MemoryBlock block = program.getMemory().getBlock(address);
        if (block == null || !block.isInitialized()) {
            return;
        }
        Address normalizedAddr = PseudoDisassembler.getNormalizedDisassemblyAddress((Program)program, (Address)address);
        if (!listing.isUndefined(normalizedAddr, normalizedAddr)) {
            Instruction instr = listing.getInstructionAt(normalizedAddr);
            if (instr == null) {
                return;
            }
        } else {
            address = PseudoDisassembler.setTargetContextForDisassembly((Program)program, (Address)address);
            DisassembleCommand cmd = new DisassembleCommand(address, null, true);
            cmd.applyTo(program, this.monitor);
        }
        FunctionManager funcMgr = program.getFunctionManager();
        Function func = funcMgr.getFunctionAt(address);
        if (func == null && (func = funcMgr.getFunctionContaining(address)) != null) {
            return;
        }
        if (func != null) {
            if (func.isThunk()) {
                return;
            }
            SourceType mostTrusted = this.getMostTrustedParameterSource(func);
            if (SourceType.ANALYSIS.isLowerPriorityThan(mostTrusted)) {
                return;
            }
        } else {
            CreateFunctionCmd createFunctionCmd = new CreateFunctionCmd(address, false);
            aMgr.schedule(createFunctionCmd, AnalysisPriority.FUNCTION_ANALYSIS.priority());
        }
        if (!this.createDataFromPointers) {
            return;
        }
        ParameterDefinition[] arguments = funcDefn.getArguments();
        DataType returnType = funcDefn.getReturnType();
        if (arguments == null || arguments.length == 0 && (returnType == null || Undefined.isUndefined((DataType)returnType))) {
            return;
        }
        ApplyFunctionSignatureCmd applyFunctionSignatureCmd = new ApplyFunctionSignatureCmd(address, (FunctionSignature)funcDefn, SourceType.ANALYSIS, true, false, DataTypeConflictHandler.DEFAULT_HANDLER, FunctionRenameOption.NO_CHANGE);
        aMgr.schedule(applyFunctionSignatureCmd, AnalysisPriority.FUNCTION_ANALYSIS.after().priority());
    }

    private SourceType getMostTrustedParameterSource(Function func) {
        Parameter[] parameters;
        SourceType highestSource = func.getSignatureSource();
        for (Parameter parameter : parameters = func.getParameters()) {
            SourceType paramSource = parameter.getSource();
            if (!paramSource.isHigherPriorityThan(highestSource)) continue;
            highestSource = paramSource;
        }
        return highestSource;
    }

    @Override
    public boolean evaluateDestination(VarnodeContext context, Instruction instruction) {
        FlowType flowType = instruction.getFlowType();
        if (!flowType.isJump()) {
            return false;
        }
        Reference[] refs = instruction.getReferencesFrom();
        if (refs.length <= 0 || refs.length == 1 && refs[0].getReferenceType().isData()) {
            this.destSet.addRange(instruction.getMinAddress(), instruction.getMinAddress());
        }
        return false;
    }

    @Override
    public boolean allowAccess(VarnodeContext context, Address addr) {
        return this.trustMemoryWrite;
    }

    int getRestrictedStringLen(Program program, Address address, AbstractStringDataType dataType, int maxLength) {
        maxLength = this.getMaxStringLength(program, address, maxLength);
        MemoryBufferImpl memoryBuffer = new MemoryBufferImpl(program.getMemory(), address);
        StringDataInstance stringDataInstance = dataType.getStringDataInstance((MemBuffer)memoryBuffer, dataType.getDefaultSettings(), -1);
        stringDataInstance.getStringDataTypeGuess();
        int detectedLength = stringDataInstance.getStringLength();
        if (detectedLength == -1) {
            return 0;
        }
        if (detectedLength > maxLength) {
            detectedLength = maxLength;
        }
        return detectedLength;
    }

    private int getMaxStringLength(Program program, Address address, int maxLen) {
        AddressIterator refIter = program.getReferenceManager().getReferenceDestinationIterator(address.next(), true);
        Address next = refIter.next();
        if (next == null) {
            return -1;
        }
        long len = -1L;
        try {
            len = next.subtract(address);
            if (len > (long)maxLen) {
                len = maxLen;
            }
            return (int)len;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return (int)len;
        }
    }
}

