/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.app.plugin.core.analysis.ScalarOperandAnalyzer;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.scalar.Scalar;

public class ElfScalarOperandAnalyzer
extends ScalarOperandAnalyzer {
    private static final String NAME = "ELF Scalar Operand References";
    private static final String DESCRIPTION = "For ELF shared objects (.so) files that are based at zero, offsets relative to the .got offsets appear to be valid addresses and therefore invalid memory references get created by the analyzer. This analyzer will remove those bad references.";

    public ElfScalarOperandAnalyzer() {
        super(NAME, DESCRIPTION);
    }

    @Override
    public boolean canAnalyze(Program program) {
        boolean elf = this.isELF(program);
        return elf;
    }

    @Override
    public boolean getDefaultEnablement(Program program) {
        if (!this.isELF(program)) {
            return false;
        }
        return this.getDefaultEnablement2(program);
    }

    @Override
    protected boolean addReference(Program program, Instruction instr, int opIndex, AddressSpace space, Scalar scalar) {
        if (program.getExecutableFormat().equals("Executable and Linking Format (ELF)")) {
            MemoryBlock block;
            if (instr.getMnemonicString().equalsIgnoreCase("add")) {
                try {
                    Address gotAddr = instr.getMinAddress().add(scalar.getUnsignedValue());
                    MemoryBlock block2 = program.getMemory().getBlock(gotAddr);
                    if (block2 != null && block2.getName().indexOf(".got") >= 0) {
                        return false;
                    }
                }
                catch (AddressOutOfBoundsException gotAddr) {}
            } else if (instr.getMnemonicString().equalsIgnoreCase("push") && (block = program.getMemory().getBlock(instr.getMinAddress())).getName().indexOf(".plt") >= 0) {
                return false;
            }
        }
        return super.addReference(program, instr, opIndex, space, scalar);
    }
}

