/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.codebrowser.hover;

import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.support.FieldLocation;
import ghidra.app.plugin.core.codebrowser.hover.ListingHoverService;
import ghidra.app.plugin.core.hover.AbstractConfigurableHover;
import ghidra.app.util.viewer.field.ListingTextField;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HTMLUtilities;
import javax.swing.JComponent;
import javax.swing.JToolTip;

public class TruncatedTextListingHover
extends AbstractConfigurableHover
implements ListingHoverService {
    private static final String NAME = "Truncated Text Display";
    private static final String DESCRIPTION = "Toggle whether truncated text is displayed in a tooltip when the mouse hovers over a field that is truncated.";
    private static final int POPUP_PRIORITY = 10;

    public TruncatedTextListingHover(PluginTool tool) {
        super(tool, 10);
    }

    @Override
    protected String getName() {
        return NAME;
    }

    @Override
    protected String getDescription() {
        return DESCRIPTION;
    }

    @Override
    protected String getOptionsCategory() {
        return "Listing Popups";
    }

    @Override
    public JComponent getHoverComponent(Program program, ProgramLocation programLocation, FieldLocation fieldLocation, Field field) {
        if (!this.enabled || programLocation == null || !(field instanceof ListingTextField)) {
            return null;
        }
        if (((ListingTextField)field).isClipped()) {
            String text = field.getTextWithLineSeparators();
            String convertToHtml = HTMLUtilities.toLiteralHTMLForTooltip((String)text);
            JToolTip toolTip = new JToolTip();
            toolTip.setTipText(convertToHtml);
            return toolTip;
        }
        return null;
    }
}

