/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.coff;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverterUtil;
import ghidra.app.util.bin.format.coff.CoffSymbolAux;
import ghidra.program.model.data.DataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class CoffSymbolAuxEndOfBlock
implements CoffSymbolAux {
    private byte[] unused1;
    private short sourceLineNumber;
    private byte[] unused2;

    CoffSymbolAuxEndOfBlock(BinaryReader reader) throws IOException {
        this.unused1 = reader.readNextByteArray(4);
        this.sourceLineNumber = reader.readNextShort();
        this.unused2 = reader.readNextByteArray(12);
    }

    public byte[] getUnused1() {
        return this.unused1;
    }

    public short getSourceLineNumber() {
        return this.sourceLineNumber;
    }

    public byte[] getUnused2() {
        return this.unused2;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        return StructConverterUtil.toDataType(this);
    }
}

