/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf.external;

import ghidra.app.util.bin.format.dwarf.external.ExternalDebugInfo;
import ghidra.app.util.bin.format.dwarf.external.SearchLocation;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.List;

public class ExternalDebugFilesService {
    private List<SearchLocation> searchLocations;

    public ExternalDebugFilesService(List<SearchLocation> searchLocations) {
        this.searchLocations = searchLocations;
    }

    public List<SearchLocation> getSearchLocations() {
        return this.searchLocations;
    }

    public FSRL findDebugFile(ExternalDebugInfo debugInfo, TaskMonitor monitor) throws IOException {
        try {
            for (SearchLocation searchLoc : this.searchLocations) {
                monitor.checkCancelled();
                FSRL result = searchLoc.findDebugFile(debugInfo, monitor);
                if (result == null) continue;
                return result;
            }
        }
        catch (CancelledException cancelledException) {
            // empty catch block
        }
        return null;
    }
}

