/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.memsearch.bytesequence;

import ghidra.features.base.memsearch.bytesequence.ByteSequence;

public class ExtendedByteSequence
implements ByteSequence {
    private ByteSequence main;
    private ByteSequence extended;
    private int extendedLength;

    public ExtendedByteSequence(ByteSequence main, ByteSequence extended, int extendedLimit) {
        this.main = main;
        this.extended = extended;
        this.extendedLength = main.getLength() + Math.min(extendedLimit, extended.getLength());
    }

    @Override
    public int getLength() {
        return this.main.getLength();
    }

    public int getExtendedLength() {
        return this.extendedLength;
    }

    @Override
    public byte getByte(int i) {
        int mainLength = this.main.getLength();
        if (i >= mainLength) {
            return this.extended.getByte(i - mainLength);
        }
        return this.main.getByte(i);
    }

    @Override
    public byte[] getBytes(int index, int size) {
        if (index < 0 || index + size > this.extendedLength) {
            throw new IndexOutOfBoundsException();
        }
        int length = this.main.getLength();
        if (index + size < length) {
            return this.main.getBytes(index, size);
        }
        if (index >= length) {
            return this.extended.getBytes(index - length, size);
        }
        byte[] results = new byte[size];
        for (int i = 0; i < size; ++i) {
            results[i] = this.getByte(index + i);
        }
        return results;
    }

    @Override
    public boolean hasAvailableBytes(int index, int length) {
        return index >= 0 && index + length <= this.getExtendedLength();
    }
}

