/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.bytesearch;

import ghidra.util.bytesearch.DittedBitSequence;
import ghidra.util.bytesearch.MatchAction;
import ghidra.util.bytesearch.Pattern;
import ghidra.util.bytesearch.PostRule;

public class Match {
    private DittedBitSequence sequence;
    private long offset;

    public Match(DittedBitSequence sequence, long offset) {
        this.sequence = sequence;
        this.offset = offset;
    }

    public int getNumPostBits() {
        if (!(this.sequence instanceof Pattern)) {
            return 0;
        }
        int marked = ((Pattern)this.sequence).getMarkOffset();
        if (marked == 0) {
            return this.sequence.getNumFixedBits();
        }
        return this.sequence.getNumFixedBits() - this.sequence.getNumInitialFixedBits(marked);
    }

    public MatchAction[] getMatchActions() {
        return ((Pattern)this.sequence).getMatchActions();
    }

    public int getSequenceSize() {
        return this.sequence.getSize();
    }

    public int getSequenceIndex() {
        return this.sequence.getIndex();
    }

    public long getMarkOffset() {
        return this.offset + (long)((Pattern)this.sequence).getMarkOffset();
    }

    public long getMatchStart() {
        return this.offset;
    }

    public boolean checkPostRules(long streamoffset) {
        PostRule[] postRules;
        long curoffset = streamoffset + this.offset;
        Pattern pattern = (Pattern)this.sequence;
        for (PostRule postRule : postRules = pattern.getPostRules()) {
            if (postRule.apply(pattern, curoffset)) continue;
            return false;
        }
        return true;
    }

    public String getHexString() {
        return this.sequence.getHexString();
    }

    public DittedBitSequence getSequence() {
        return this.sequence;
    }
}

