/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util;

import java.nio.ByteBuffer;

public interface ByteBufferUtils {
    public static ByteBuffer resize(ByteBuffer buf, int capacity) {
        if (capacity < buf.limit()) {
            throw new IllegalArgumentException("New capacity must fit current contents");
        }
        buf.flip();
        ByteBuffer resized = ByteBuffer.allocate(capacity);
        resized.put(buf);
        return resized;
    }

    public static ByteBuffer upsize(ByteBuffer buf) {
        return ByteBufferUtils.resize(buf, buf.capacity() * 2);
    }

    public static boolean maskedEquals(ByteBuffer mask, ByteBuffer a, ByteBuffer b) {
        int len = a.capacity();
        if (mask != null && mask.capacity() != len) {
            throw new IllegalArgumentException("mask and a must have equal capacities");
        }
        if (len != a.capacity()) {
            return false;
        }
        if (mask != null) {
            for (int i = 0; i < len; ++i) {
                if ((a.get(i) & mask.get(i)) == (b.get(i) & mask.get(i))) continue;
                return false;
            }
            return true;
        }
        for (int i = 0; i < len; ++i) {
            if (a.get(i) == b.get(i)) continue;
            return false;
        }
        return true;
    }
}

