/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.task;

import ghidra.feature.vt.gui.wizard.session.VTWizardUtils;
import ghidra.framework.model.DomainFile;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class SaveTask
extends Task {
    private final DomainFile domainFile;
    private boolean didSave;

    public SaveTask(DomainFile domainFile) {
        super("Saving File: " + domainFile.getName(), true, true, true);
        this.domainFile = domainFile;
    }

    public void run(TaskMonitor monitor) {
        monitor.setMessage("Saving " + this.domainFile.getName() + "...");
        try {
            this.domainFile.save(monitor);
            this.didSave = true;
        }
        catch (CancelledException e) {
            this.didSave = false;
        }
        catch (IOException e) {
            Msg.error(VTWizardUtils.class, (Object)"Unexpected error saving file", (Throwable)e);
            this.didSave = false;
        }
    }

    public boolean didSave() {
        return this.didSave;
    }
}

