/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.partitioning;

import java.io.PrintStream;
import org.catacombae.hfsexplorer.Util;
import org.catacombae.hfsexplorer.partitioning.Partition;
import org.catacombae.jparted.lib.ps.PartitionType;

public class APMPartition
implements Partition {
    private final byte[] pmSig = new byte[2];
    private final byte[] pmSigPad = new byte[2];
    private final byte[] pmMapBlkCnt = new byte[4];
    private final byte[] pmPyPartStart = new byte[4];
    private final byte[] pmPartBlkCnt = new byte[4];
    private final byte[] pmPartName = new byte[32];
    private final byte[] pmParType = new byte[32];
    private final byte[] pmLgDataStart = new byte[4];
    private final byte[] pmDataCnt = new byte[4];
    private final byte[] pmPartStatus = new byte[4];
    private final byte[] pmLgBootStart = new byte[4];
    private final byte[] pmBootSize = new byte[4];
    private final byte[] pmBootAddr = new byte[4];
    private final byte[] pmBootAddr2 = new byte[4];
    private final byte[] pmBootEntry = new byte[4];
    private final byte[] pmBootEntry2 = new byte[4];
    private final byte[] pmBootCksum = new byte[4];
    private final byte[] pmProcessor = new byte[16];
    private final byte[] pmPad = new byte[376];
    private final int blockSize;

    public APMPartition(byte[] data, int offset, int blockSize) {
        System.arraycopy(data, offset + 0, this.pmSig, 0, 2);
        System.arraycopy(data, offset + 2, this.pmSigPad, 0, 2);
        System.arraycopy(data, offset + 4, this.pmMapBlkCnt, 0, 4);
        System.arraycopy(data, offset + 8, this.pmPyPartStart, 0, 4);
        System.arraycopy(data, offset + 12, this.pmPartBlkCnt, 0, 4);
        System.arraycopy(data, offset + 16, this.pmPartName, 0, 32);
        System.arraycopy(data, offset + 48, this.pmParType, 0, 32);
        System.arraycopy(data, offset + 80, this.pmLgDataStart, 0, 4);
        System.arraycopy(data, offset + 84, this.pmDataCnt, 0, 4);
        System.arraycopy(data, offset + 88, this.pmPartStatus, 0, 4);
        System.arraycopy(data, offset + 92, this.pmLgBootStart, 0, 4);
        System.arraycopy(data, offset + 96, this.pmBootSize, 0, 4);
        System.arraycopy(data, offset + 100, this.pmBootAddr, 0, 4);
        System.arraycopy(data, offset + 104, this.pmBootAddr2, 0, 4);
        System.arraycopy(data, offset + 108, this.pmBootEntry, 0, 4);
        System.arraycopy(data, offset + 112, this.pmBootEntry2, 0, 4);
        System.arraycopy(data, offset + 116, this.pmBootCksum, 0, 4);
        System.arraycopy(data, offset + 120, this.pmProcessor, 0, 16);
        System.arraycopy(data, offset + 136, this.pmPad, 0, 376);
        this.blockSize = blockSize;
    }

    public static int structSize() {
        return 512;
    }

    public long getStartOffset() {
        return (Util.unsign(this.getPmPyPartStart()) + Util.unsign(this.getPmLgDataStart())) * (long)this.blockSize;
    }

    public long getLength() {
        return Util.unsign(this.getPmDataCnt()) * (long)this.blockSize;
    }

    public PartitionType getType() {
        return this.convertPartitionType(this.getPmParType());
    }

    public short getPmSig() {
        return Util.readShortBE(this.pmSig);
    }

    public short getPmSigPad() {
        return Util.readShortBE(this.pmSigPad);
    }

    public int getPmMapBlkCnt() {
        return Util.readIntBE(this.pmMapBlkCnt);
    }

    public int getPmPyPartStart() {
        return Util.readIntBE(this.pmPyPartStart);
    }

    public int getPmPartBlkCnt() {
        return Util.readIntBE(this.pmPartBlkCnt);
    }

    public byte[] getPmPartName() {
        return Util.createCopy(this.pmPartName);
    }

    public byte[] getPmParType() {
        return Util.createCopy(this.pmParType);
    }

    public int getPmLgDataStart() {
        return Util.readIntBE(this.pmLgDataStart);
    }

    public int getPmDataCnt() {
        return Util.readIntBE(this.pmDataCnt);
    }

    public int getPmPartStatus() {
        return Util.readIntBE(this.pmPartStatus);
    }

    public int getPmLgBootStart() {
        return Util.readIntBE(this.pmLgBootStart);
    }

    public int getPmBootSize() {
        return Util.readIntBE(this.pmBootSize);
    }

    public int getPmBootAddr() {
        return Util.readIntBE(this.pmBootAddr);
    }

    public int getPmBootAddr2() {
        return Util.readIntBE(this.pmBootAddr2);
    }

    public int getPmBootEntry() {
        return Util.readIntBE(this.pmBootEntry);
    }

    public int getPmBootEntry2() {
        return Util.readIntBE(this.pmBootEntry2);
    }

    public int getPmBootCksum() {
        return Util.readIntBE(this.pmBootCksum);
    }

    public byte[] getPmProcessor() {
        return Util.createCopy(this.pmProcessor);
    }

    public short[] getPmPad() {
        return Util.readShortArrayBE(this.pmPad);
    }

    public String getPmSigAsString() {
        return Util.toASCIIString(this.pmSig);
    }

    public String getPmPartNameAsString() {
        return Util.readNullTerminatedASCIIString(this.pmPartName);
    }

    public String getPmParTypeAsString() {
        return Util.readNullTerminatedASCIIString(this.pmParType);
    }

    public String getPmProcessorAsString() {
        return Util.readNullTerminatedASCIIString(this.pmProcessor);
    }

    public boolean isValid() {
        int pmSigInt = this.getPmSig() & 0xFFFF;
        return pmSigInt == 20557 || pmSigInt == 21587;
    }

    public void printPartitionInfo(PrintStream ps) {
        this.printPartitionInfo(ps, "");
    }

    public void printPartitionInfo(PrintStream ps, String prefix) {
        ps.println(prefix + "pmSig: \"" + this.getPmSigAsString() + "\"");
        ps.println(prefix + "pmSigPad: " + this.getPmSigPad());
        ps.println(prefix + "pmMapBlkCnt: " + this.getPmMapBlkCnt());
        ps.println(prefix + "pmPyPartStart: " + this.getPmPyPartStart());
        ps.println(prefix + "pmPartBlkCnt: " + this.getPmPartBlkCnt());
        ps.println(prefix + "pmPartName: \"" + this.getPmPartNameAsString() + "\"");
        ps.println(prefix + "pmParType: \"" + this.getPmParTypeAsString() + "\"");
        ps.println(prefix + "pmLgDataStart: " + this.getPmLgDataStart());
        ps.println(prefix + "pmDataCnt: " + this.getPmDataCnt());
        ps.println(prefix + "pmPartStatus: " + this.getPmPartStatus());
        ps.println(prefix + "pmLgBootStart: " + this.getPmLgBootStart());
        ps.println(prefix + "pmBootSize: " + this.getPmBootSize());
        ps.println(prefix + "pmBootAddr: " + this.getPmBootAddr());
        ps.println(prefix + "pmBootAddr2: " + this.getPmBootAddr2());
        ps.println(prefix + "pmBootEntry: " + this.getPmBootEntry());
        ps.println(prefix + "pmBootEntry2: " + this.getPmBootEntry2());
        ps.println(prefix + "pmBootCksum: " + this.getPmBootCksum());
        ps.println(prefix + "pmProcessor: \"" + this.getPmProcessorAsString() + "\"");
        ps.println(prefix + "pmPad: " + this.getPmPad());
    }

    public byte[] getData() {
        byte[] result = new byte[APMPartition.structSize()];
        int offset = 0;
        System.arraycopy(this.pmSig, 0, result, offset, this.pmSig.length);
        System.arraycopy(this.pmSigPad, 0, result, offset += this.pmSig.length, this.pmSigPad.length);
        System.arraycopy(this.pmMapBlkCnt, 0, result, offset += this.pmSigPad.length, this.pmMapBlkCnt.length);
        System.arraycopy(this.pmPyPartStart, 0, result, offset += this.pmMapBlkCnt.length, this.pmPyPartStart.length);
        System.arraycopy(this.pmPartBlkCnt, 0, result, offset += this.pmPyPartStart.length, this.pmPartBlkCnt.length);
        System.arraycopy(this.pmPartName, 0, result, offset += this.pmPartBlkCnt.length, this.pmPartName.length);
        System.arraycopy(this.pmParType, 0, result, offset += this.pmPartName.length, this.pmParType.length);
        System.arraycopy(this.pmLgDataStart, 0, result, offset += this.pmParType.length, this.pmLgDataStart.length);
        System.arraycopy(this.pmDataCnt, 0, result, offset += this.pmLgDataStart.length, this.pmDataCnt.length);
        System.arraycopy(this.pmPartStatus, 0, result, offset += this.pmDataCnt.length, this.pmPartStatus.length);
        System.arraycopy(this.pmLgBootStart, 0, result, offset += this.pmPartStatus.length, this.pmLgBootStart.length);
        System.arraycopy(this.pmBootSize, 0, result, offset += this.pmLgBootStart.length, this.pmBootSize.length);
        System.arraycopy(this.pmBootAddr, 0, result, offset += this.pmBootSize.length, this.pmBootAddr.length);
        System.arraycopy(this.pmBootAddr2, 0, result, offset += this.pmBootAddr.length, this.pmBootAddr2.length);
        System.arraycopy(this.pmBootEntry, 0, result, offset += this.pmBootAddr2.length, this.pmBootEntry.length);
        System.arraycopy(this.pmBootEntry2, 0, result, offset += this.pmBootEntry.length, this.pmBootEntry2.length);
        System.arraycopy(this.pmBootCksum, 0, result, offset += this.pmBootEntry2.length, this.pmBootCksum.length);
        System.arraycopy(this.pmProcessor, 0, result, offset += this.pmBootCksum.length, this.pmProcessor.length);
        System.arraycopy(this.pmPad, 0, result, offset += this.pmProcessor.length, this.pmPad.length);
        if ((offset += this.pmPad.length) != result.length) {
            throw new RuntimeException("Internal miscalculation...");
        }
        return result;
    }

    public void printFields(PrintStream ps, String prefix) {
        this.printPartitionInfo(ps, prefix + " ");
        ps.println(prefix + " Partition methods: ");
        ps.println(prefix + "  getStartOffset(): " + this.getStartOffset());
        ps.println(prefix + "  getLength(): " + this.getLength());
        ps.println(prefix + "  getType(): " + (Object)((Object)this.getType()));
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "APMPartition:");
        this.printFields(ps, prefix);
    }

    public String toString() {
        return "\"" + this.getPmPartNameAsString() + "\" (" + this.getPmParTypeAsString() + ")";
    }

    public PartitionType convertPartitionType(byte[] parTypeData) {
        String typeString = Util.readNullTerminatedASCIIString(parTypeData);
        if (typeString.equals("Apple_partition_map")) {
            return PartitionType.APPLE_PARTITION_MAP;
        }
        if (typeString.equals("Apple_Driver")) {
            return PartitionType.APPLE_DRIVER;
        }
        if (typeString.equals("Apple_Driver43")) {
            return PartitionType.APPLE_DRIVER43;
        }
        if (typeString.equals("Apple_MFS")) {
            return PartitionType.APPLE_MFS;
        }
        if (typeString.equals("Apple_HFS")) {
            return PartitionType.APPLE_HFS_CONTAINER;
        }
        if (typeString.equals("Apple_HFSX")) {
            return PartitionType.APPLE_HFSX;
        }
        if (typeString.equals("Apple_Unix_SVR2")) {
            return PartitionType.APPLE_UNIX_SVR2;
        }
        if (typeString.equals("Apple_PRODOS")) {
            return PartitionType.APPLE_PRODOS;
        }
        if (typeString.equals("Apple_Free")) {
            return PartitionType.EMPTY;
        }
        if (typeString.equals("Apple_Scratch")) {
            return PartitionType.EMPTY;
        }
        return PartitionType.UNKNOWN;
    }
}

