/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.assembler.sleigh.expr;

import ghidra.app.plugin.assembler.sleigh.expr.AbstractExpressionSolver;
import ghidra.app.plugin.assembler.sleigh.expr.AndExpressionSolver;
import ghidra.app.plugin.assembler.sleigh.expr.ConstantValueSolver;
import ghidra.app.plugin.assembler.sleigh.expr.ContextFieldSolver;
import ghidra.app.plugin.assembler.sleigh.expr.DivExpressionSolver;
import ghidra.app.plugin.assembler.sleigh.expr.EndInstructionValueSolver;
import ghidra.app.plugin.assembler.sleigh.expr.LeftShiftExpressionSolver;
import ghidra.app.plugin.assembler.sleigh.expr.MaskedLong;
import ghidra.app.plugin.assembler.sleigh.expr.MinusExpressionSolver;
import ghidra.app.plugin.assembler.sleigh.expr.MultExpressionSolver;
import ghidra.app.plugin.assembler.sleigh.expr.NeedsBackfillException;
import ghidra.app.plugin.assembler.sleigh.expr.Next2InstructionValueSolver;
import ghidra.app.plugin.assembler.sleigh.expr.NotExpressionSolver;
import ghidra.app.plugin.assembler.sleigh.expr.OperandValueSolver;
import ghidra.app.plugin.assembler.sleigh.expr.OrExpressionSolver;
import ghidra.app.plugin.assembler.sleigh.expr.PlusExpressionSolver;
import ghidra.app.plugin.assembler.sleigh.expr.RightShiftExpressionSolver;
import ghidra.app.plugin.assembler.sleigh.expr.SolverHint;
import ghidra.app.plugin.assembler.sleigh.expr.StartInstructionValueSolver;
import ghidra.app.plugin.assembler.sleigh.expr.SubExpressionSolver;
import ghidra.app.plugin.assembler.sleigh.expr.TokenFieldSolver;
import ghidra.app.plugin.assembler.sleigh.expr.XorExpressionSolver;
import ghidra.app.plugin.assembler.sleigh.sem.AbstractAssemblyResolutionFactory;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolution;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedPatterns;
import ghidra.app.plugin.assembler.sleigh.util.DbgTimer;
import ghidra.app.plugin.processors.sleigh.expression.PatternExpression;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class RecursiveDescentSolver {
    protected static final DbgTimer DBG = DbgTimer.INACTIVE;
    private static final RecursiveDescentSolver INSTANCE = new RecursiveDescentSolver();
    protected Map<Class<?>, AbstractExpressionSolver<?>> registry = new HashMap();

    public RecursiveDescentSolver() {
        new AndExpressionSolver().register(this);
        new ConstantValueSolver().register(this);
        new ContextFieldSolver().register(this);
        new DivExpressionSolver().register(this);
        new EndInstructionValueSolver().register(this);
        new Next2InstructionValueSolver().register(this);
        new LeftShiftExpressionSolver().register(this);
        new MinusExpressionSolver().register(this);
        new MultExpressionSolver().register(this);
        new NotExpressionSolver().register(this);
        new OperandValueSolver().register(this);
        new OrExpressionSolver().register(this);
        new PlusExpressionSolver().register(this);
        new RightShiftExpressionSolver().register(this);
        new StartInstructionValueSolver().register(this);
        new SubExpressionSolver().register(this);
        new TokenFieldSolver().register(this);
        new XorExpressionSolver().register(this);
    }

    public static RecursiveDescentSolver getSolver() {
        return INSTANCE;
    }

    protected <T extends PatternExpression> void register(Class<T> tcls, AbstractExpressionSolver<T> s) {
        this.registry.put(tcls, s);
    }

    protected <T extends PatternExpression> AbstractExpressionSolver<T> getRegistered(Class<?> tcls) {
        AbstractExpressionSolver<?> s = this.registry.get(tcls);
        if (s == null) {
            throw new RuntimeException("No registered solver for class " + String.valueOf(tcls));
        }
        return s;
    }

    protected AssemblyResolution solve(AbstractAssemblyResolutionFactory<?, ?> factory, PatternExpression exp, MaskedLong goal, Map<String, Long> vals, AssemblyResolvedPatterns cur, Set<SolverHint> hints, String description) throws NeedsBackfillException {
        try {
            return this.getRegistered(exp.getClass()).solve(factory, exp, goal, vals, cur, hints, description);
        }
        catch (UnsupportedOperationException e) {
            DBG.println("Error solving " + String.valueOf(exp) + " = " + String.valueOf(goal));
            throw e;
        }
    }

    public AssemblyResolution solve(AbstractAssemblyResolutionFactory<?, ?> factory, PatternExpression exp, MaskedLong goal, Map<String, Long> vals, AssemblyResolvedPatterns cur, String description) throws NeedsBackfillException {
        return this.solve(factory, exp, goal, vals, cur, Set.of(), description);
    }

    protected <T extends PatternExpression> MaskedLong getValue(T exp, Map<String, Long> vals, AssemblyResolvedPatterns cur) throws NeedsBackfillException {
        MaskedLong value = this.getRegistered(exp.getClass()).getValue(exp, vals, cur);
        DBG.println("Expression: " + String.valueOf(value) + " =: " + String.valueOf(exp));
        return value;
    }

    public int getInstructionLength(PatternExpression exp) {
        return this.getRegistered(exp.getClass()).getInstructionLength(exp);
    }

    public MaskedLong valueForResolution(PatternExpression exp, Map<String, Long> vals, AssemblyResolvedPatterns rc) {
        return this.getRegistered(exp.getClass()).valueForResolution(exp, vals, rc);
    }
}

