/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.assembler.sleigh.parse;

import ghidra.app.plugin.assembler.sleigh.symbol.AssemblySymbol;
import ghidra.app.plugin.assembler.sleigh.util.TableEntry;
import ghidra.app.plugin.assembler.sleigh.util.TableEntryKey;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;

public class AssemblyParseTransitionTable {
    private final Map<TableEntryKey, Integer> map = new TreeMap<TableEntryKey, Integer>();

    public Integer put(int fromState, AssemblySymbol next, int newState) {
        return this.map.put(new TableEntryKey(fromState, next), newState);
    }

    public Integer get(int fromState, AssemblySymbol next) {
        return this.map.get(new TableEntryKey(fromState, next));
    }

    public void forEach(Consumer<TableEntry<Integer>> consumer) {
        for (Map.Entry<TableEntryKey, Integer> ent : this.map.entrySet()) {
            consumer.accept(new TableEntry<Integer>(ent.getKey().getState(), ent.getKey().getSym(), ent.getValue()));
        }
    }
}

