/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.symbol;

import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.LongField;
import db.RecordIterator;
import db.Table;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.map.AddressRecordDeleter;
import ghidra.program.database.symbol.LabelHistoryAdapter;
import ghidra.program.database.util.DatabaseTableUtils;
import ghidra.program.database.util.RecordFilter;
import ghidra.program.model.address.Address;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.Date;
import java.util.Set;

class LabelHistoryAdapterV0
extends LabelHistoryAdapter {
    private Table table;
    private String userName;

    LabelHistoryAdapterV0(DBHandle handle, boolean create) throws VersionException, IOException {
        if (create) {
            this.table = handle.createTable("Label History", LABEL_HISTORY_SCHEMA, new int[]{0});
        } else {
            this.table = handle.getTable("Label History");
            if (this.table == null) {
                throw new VersionException(true);
            }
            if (this.table.getSchema().getVersion() != 0) {
                throw new VersionException(2, false);
            }
        }
        this.userName = SystemUtilities.getUserName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static LabelHistoryAdapter upgrade(DBHandle dbHandle, AddressMap addrMap, LabelHistoryAdapter oldAdapter, TaskMonitor monitor) throws VersionException, IOException, CancelledException {
        AddressMap oldAddrMap = addrMap.getOldAddressMap();
        try (DBHandle tmpHandle = new DBHandle();){
            tmpHandle.startTransaction();
            monitor.setMessage("Upgrading Label History...");
            monitor.initialize((long)(oldAdapter.getRecordCount() * 2));
            int count = 0;
            LabelHistoryAdapterV0 tmpAdapter = new LabelHistoryAdapterV0(tmpHandle, true);
            RecordIterator iter = oldAdapter.getAllRecords();
            while (iter.hasNext()) {
                if (monitor.isCancelled()) {
                    throw new CancelledException();
                }
                DBRecord rec = iter.next();
                Address addr = oldAddrMap.decodeAddress(rec.getLongValue(0));
                rec.setLongValue(0, addrMap.getKey(addr, true));
                tmpAdapter.table.putRecord(rec);
                monitor.setProgress((long)(++count));
            }
            dbHandle.deleteTable("Label History");
            LabelHistoryAdapterV0 newAdapter = new LabelHistoryAdapterV0(dbHandle, true);
            iter = tmpAdapter.getAllRecords();
            while (iter.hasNext()) {
                if (monitor.isCancelled()) {
                    throw new CancelledException();
                }
                DBRecord rec = iter.next();
                newAdapter.table.putRecord(rec);
                monitor.setProgress((long)(++count));
            }
            LabelHistoryAdapterV0 labelHistoryAdapterV0 = newAdapter;
            return labelHistoryAdapterV0;
        }
    }

    @Override
    public void createRecord(long addr, byte actionID, String labelStr) throws IOException {
        DBRecord rec = this.table.getSchema().createRecord(this.table.getKey());
        rec.setLongValue(0, addr);
        rec.setByteValue(1, actionID);
        rec.setString(2, labelStr);
        rec.setString(3, this.userName);
        rec.setLongValue(4, new Date().getTime());
        this.table.putRecord(rec);
    }

    @Override
    public RecordIterator getAllRecords() throws IOException {
        return this.table.iterator();
    }

    @Override
    public RecordIterator getRecordsByAddress(long addr) throws IOException {
        LongField field = new LongField(addr);
        return this.table.indexIterator(0, (Field)field, (Field)field, true);
    }

    @Override
    int getRecordCount() {
        return this.table.getRecordCount();
    }

    @Override
    void moveAddress(long oldAddr, long newAddr) throws IOException {
        Field[] keys;
        for (Field key : keys = this.table.findRecords((Field)new LongField(oldAddr), 0)) {
            DBRecord rec = this.table.getRecord(key);
            rec.setLongValue(0, newAddr);
            this.table.putRecord(rec);
        }
    }

    @Override
    void moveAddressRange(Address fromAddr, Address toAddr, long length, AddressMap addrMap, TaskMonitor monitor) throws CancelledException, IOException {
        DatabaseTableUtils.updateIndexedAddressField(this.table, 0, addrMap, fromAddr, toAddr, length, null, monitor);
    }

    @Override
    void deleteAddressRange(Address startAddr, Address endAddr, final AddressMap addrMap, final Set<Address> set, TaskMonitor monitor) throws CancelledException, IOException {
        RecordFilter filter = new RecordFilter(){

            @Override
            public boolean matches(DBRecord record) {
                Address addr = addrMap.decodeAddress(record.getLongValue(0));
                return set == null || !set.contains(addr);
            }
        };
        AddressRecordDeleter.deleteRecords(this.table, 0, addrMap, startAddr, endAddr, filter);
    }
}

