/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.disassemble;

import ghidra.program.disassemble.DisassemblerConflictHandler;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.SegmentedAddress;
import ghidra.program.model.lang.InstructionBlock;
import ghidra.program.model.lang.InstructionBlockFlow;
import ghidra.program.model.lang.InstructionError;
import ghidra.program.model.lang.InstructionSet;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.util.task.TaskMonitor;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

class DisassemblerQueue {
    private TreeSet<InstructionBlockFlow> orderedSeedQueue;
    private TreeSet<InstructionBlockFlow> priorityQueue;
    private TreeSet<InstructionBlockFlow> currentBranchQueue;
    private HashSet<InstructionBlockFlow> processedBranchFlows;
    private AddressSetView restrictedAddressSet;
    private InstructionBlock lastBlock;
    private Address lastBlockAddr;
    private Address lastFlowFrom;
    private static final Comparator<InstructionBlockFlow> ORDERED_FLOW_COMPARATOR = new Comparator<InstructionBlockFlow>(){

        @Override
        public int compare(InstructionBlockFlow o1, InstructionBlockFlow o2) {
            int c = o1.getType().ordinal() - o2.getType().ordinal();
            if (c == 0) {
                c = o1.getDestinationAddress().compareTo(o2.getDestinationAddress());
            }
            return c;
        }
    };

    DisassemblerQueue(Address startAddr, AddressSetView restrictedAddressSet) {
        this.restrictedAddressSet = restrictedAddressSet;
        this.orderedSeedQueue = new TreeSet<InstructionBlockFlow>(ORDERED_FLOW_COMPARATOR);
        this.priorityQueue = new TreeSet<InstructionBlockFlow>(ORDERED_FLOW_COMPARATOR);
        this.currentBranchQueue = new TreeSet<InstructionBlockFlow>(ORDERED_FLOW_COMPARATOR);
        this.processedBranchFlows = new HashSet(48);
        this.orderedSeedQueue.add(new InstructionBlockFlow(startAddr, null, InstructionBlockFlow.Type.PRIORITY));
    }

    boolean continueProducingInstructionSets(TaskMonitor monitor) {
        this.currentBranchQueue.clear();
        this.processedBranchFlows.clear();
        this.lastBlock = null;
        this.lastBlockAddr = null;
        this.lastFlowFrom = null;
        if (monitor != null && monitor.isCancelled()) {
            return false;
        }
        if (!this.priorityQueue.isEmpty()) {
            return true;
        }
        if (this.orderedSeedQueue.isEmpty()) {
            return false;
        }
        InstructionBlockFlow flow = this.orderedSeedQueue.first();
        this.orderedSeedQueue.remove(flow);
        this.priorityQueue.add(flow);
        return true;
    }

    InstructionBlock getNextBlockToBeDisassembled(Address fallThruAddr, Memory memory, TaskMonitor monitor) {
        if (monitor != null && monitor.isCancelled()) {
            this.lastBlock = null;
            return null;
        }
        if (fallThruAddr != null) {
            if (this.lastBlock == null) {
                throw new IllegalStateException();
            }
            if (fallThruAddr.equals(this.lastBlockAddr)) {
                return this.lastBlock;
            }
            this.lastFlowFrom = this.lastBlockAddr;
            this.lastBlockAddr = fallThruAddr;
            if (this.checkMemoryRestriction(fallThruAddr)) {
                this.lastFlowFrom = this.lastBlockAddr;
                this.lastBlockAddr = fallThruAddr;
                return this.lastBlock;
            }
        }
        this.lastBlock = null;
        this.lastBlockAddr = null;
        this.lastFlowFrom = null;
        while (!(monitor != null && monitor.isCancelled() || fallThruAddr == null && this.priorityQueue.isEmpty() && this.currentBranchQueue.isEmpty())) {
            boolean forcedStartOfFlow = false;
            InstructionBlockFlow branchFlow = null;
            if (!this.priorityQueue.isEmpty()) {
                branchFlow = this.priorityQueue.first();
                this.priorityQueue.remove(branchFlow);
                forcedStartOfFlow = true;
            } else if (!this.currentBranchQueue.isEmpty()) {
                branchFlow = this.currentBranchQueue.first();
                this.currentBranchQueue.remove(branchFlow);
            }
            this.processedBranchFlows.add(branchFlow);
            Address blockAddr = branchFlow.getDestinationAddress();
            if (blockAddr instanceof SegmentedAddress) {
                blockAddr = this.normalize((SegmentedAddress)blockAddr, memory);
            }
            if (!this.checkMemoryRestriction(blockAddr)) continue;
            this.lastBlockAddr = blockAddr;
            this.lastFlowFrom = branchFlow.getFlowFromAddress();
            this.lastBlock = new InstructionBlock(this.lastBlockAddr);
            this.lastBlock.setFlowFromAddress(this.lastFlowFrom);
            this.lastBlock.setStartOfFlow(forcedStartOfFlow);
            break;
        }
        return this.lastBlock;
    }

    int instructionSetAddedToProgram(InstructionSet instructionSet, DisassemblerConflictHandler conflictHandler) {
        int disassembleCount = 0;
        AddressSet conflictAddrs = new AddressSet();
        for (InstructionBlock block : instructionSet) {
            int instrCount;
            InstructionError conflict = block.getInstructionConflict();
            if (conflict != null) {
                conflictHandler.markInstructionError(conflict);
                Address conflictAddr = conflict.getInstructionAddress();
                Address blockEndAddr = block.getMaxAddress();
                if (conflictAddr.compareTo(blockEndAddr) <= 0) {
                    conflictAddrs.addRange(conflictAddr, blockEndAddr);
                }
            }
            if ((instrCount = block.getInstructionsAddedCount()) == 0) continue;
            List<InstructionBlockFlow> blockFlows = block.getBlockFlows();
            if (blockFlows != null) {
                for (InstructionBlockFlow blockFlow : blockFlows) {
                    InstructionBlockFlow.Type flowType = blockFlow.getType();
                    if (flowType != InstructionBlockFlow.Type.CALL && this.processedBranchFlows.contains(blockFlow) || conflict != null && conflict.getInstructionAddress().compareTo(blockFlow.getFlowFromAddress()) <= 0) continue;
                    if (flowType == InstructionBlockFlow.Type.CALL) {
                        this.orderedSeedQueue.add(blockFlow);
                        continue;
                    }
                    this.priorityQueue.add(blockFlow);
                }
            }
            disassembleCount += instrCount;
        }
        Iterator<InstructionBlock> emptyBlockIterator = instructionSet.emptyBlockIterator();
        while (emptyBlockIterator.hasNext()) {
            InstructionError conflict;
            InstructionBlock emptyBlock = emptyBlockIterator.next();
            Address flowFromAddress = emptyBlock.getFlowFromAddress();
            if (flowFromAddress != null && conflictAddrs.contains(flowFromAddress) || (conflict = emptyBlock.getInstructionConflict()) == null) continue;
            conflictHandler.markInstructionError(conflict);
        }
        return disassembleCount;
    }

    Address getDisassemblyAddress() {
        return this.lastBlockAddr;
    }

    Address getDisassemblyFlowFromAddress() {
        return this.lastFlowFrom;
    }

    void queueDelaySlotFallthrough(Instruction delaySlotInstruction) {
        InstructionBlockFlow dsFallThrough = new InstructionBlockFlow(delaySlotInstruction.getMaxAddress().next(), delaySlotInstruction.getAddress(), InstructionBlockFlow.Type.PRIORITY);
        this.priorityQueue.add(dsFallThrough);
    }

    void queueCurrentFlow(InstructionBlockFlow flow) {
        this.currentBranchQueue.add(flow);
    }

    private boolean checkMemoryRestriction(Address addr) {
        return this.restrictedAddressSet == null || this.restrictedAddressSet.contains(addr);
    }

    private Address normalize(SegmentedAddress addr, Memory memory) {
        if (memory == null) {
            return addr;
        }
        MemoryBlock block = memory.getBlock(addr);
        if (block == null) {
            return addr;
        }
        SegmentedAddress start = (SegmentedAddress)block.getStart();
        return addr.normalize(start.getSegment());
    }
}

