/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.program.model.data.CharDataType;
import ghidra.program.model.data.DataOrganization;
import ghidra.program.model.data.DataTypeManager;

public class SignedCharDataType
extends CharDataType {
    public static final SignedCharDataType dataType = new SignedCharDataType();

    public SignedCharDataType() {
        this(null);
    }

    public SignedCharDataType(DataTypeManager dtm) {
        super("schar", dtm);
    }

    @Override
    public boolean isSigned() {
        return true;
    }

    @Override
    public String getDescription() {
        return "Signed Character (ASCII)";
    }

    @Override
    public SignedCharDataType clone(DataTypeManager dtm) {
        if (dtm == this.getDataTypeManager()) {
            return this;
        }
        return new SignedCharDataType(dtm);
    }

    @Override
    public String getDefaultLabelPrefix() {
        return "SCHAR";
    }

    @Override
    public String getCDeclaration() {
        return "signed char";
    }

    @Override
    public String getCTypeDeclaration(DataOrganization dataOrganization) {
        return this.getCTypeDeclaration(this.getName(), this.getCDeclaration(), false);
    }
}

