/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang;

import ghidra.app.plugin.processors.sleigh.SleighException;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.app.plugin.processors.sleigh.UniqueLayout;
import ghidra.app.plugin.processors.sleigh.template.ConstructTpl;
import ghidra.program.model.lang.ConstantPool;
import ghidra.program.model.lang.InjectContext;
import ghidra.program.model.lang.InjectPayload;
import ghidra.program.model.lang.InjectPayloadCallfixup;
import ghidra.program.model.lang.InjectPayloadCallother;
import ghidra.program.model.lang.InjectPayloadSegment;
import ghidra.program.model.lang.InjectPayloadSleigh;
import ghidra.program.model.lang.PcodeParser;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.Encoder;
import ghidra.sleigh.grammar.Location;
import ghidra.util.Msg;
import ghidra.xml.XmlParseException;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class PcodeInjectLibrary {
    protected SleighLanguage language;
    protected long uniqueBase;
    private Map<String, InjectPayload> callFixupMap;
    private Map<String, InjectPayload> callOtherFixupMap;
    private InjectPayload[] callOtherOverride;
    private Map<String, InjectPayload> callMechFixupMap;
    private Map<String, InjectPayload> exePcodeMap;
    private InjectPayloadSleigh[] programPayload;

    public PcodeInjectLibrary(SleighLanguage l) {
        this.language = l;
        this.uniqueBase = UniqueLayout.INJECT.getOffset(l);
        this.callFixupMap = new TreeMap<String, InjectPayload>();
        this.callOtherFixupMap = new TreeMap<String, InjectPayload>();
        this.callOtherOverride = null;
        this.callMechFixupMap = new TreeMap<String, InjectPayload>();
        this.exePcodeMap = new TreeMap<String, InjectPayload>();
        this.programPayload = null;
    }

    public PcodeInjectLibrary(PcodeInjectLibrary op2) {
        this.language = op2.language;
        this.uniqueBase = op2.uniqueBase;
        this.callFixupMap = new TreeMap<String, InjectPayload>(op2.callFixupMap);
        this.callOtherFixupMap = new TreeMap<String, InjectPayload>(op2.callOtherFixupMap);
        this.callOtherOverride = op2.callOtherOverride;
        this.callMechFixupMap = new TreeMap<String, InjectPayload>(op2.callMechFixupMap);
        this.exePcodeMap = new TreeMap<String, InjectPayload>(op2.exePcodeMap);
        this.programPayload = op2.programPayload;
    }

    public PcodeInjectLibrary clone() {
        return new PcodeInjectLibrary(this);
    }

    public InjectPayloadSleigh[] getProgramPayloads() {
        return this.programPayload;
    }

    public boolean hasProgramPayload(String nm, int type) {
        if (this.programPayload == null) {
            return false;
        }
        for (InjectPayloadSleigh payload : this.programPayload) {
            if (payload.getType() != type || !payload.getName().equals(nm)) continue;
            return true;
        }
        return false;
    }

    public boolean isOverride(String nm, int type) {
        if (this.callOtherOverride == null || type != 2) {
            return false;
        }
        for (InjectPayload payload : this.callOtherOverride) {
            if (!payload.getName().equals(nm)) continue;
            return true;
        }
        return false;
    }

    public InjectPayload getPayload(int type, String name) {
        if (name == null) {
            return null;
        }
        if (type == 1) {
            return this.callFixupMap.get(name);
        }
        if (type == 2) {
            return this.callOtherFixupMap.get(name);
        }
        if (type == 3) {
            return this.callMechFixupMap.get(name);
        }
        if (type == 4) {
            return this.exePcodeMap.get(name);
        }
        return null;
    }

    public void parseInject(InjectPayload payload) throws SleighException {
        InjectPayload.InjectParameter[] output;
        InjectPayload.InjectParameter[] input;
        String sourceName = payload.getSource();
        if (sourceName == null) {
            sourceName = "unknown";
        }
        if (!(payload instanceof InjectPayloadSleigh)) {
            return;
        }
        InjectPayloadSleigh payloadSleigh = (InjectPayloadSleigh)payload;
        String pcodeText = payloadSleigh.releaseParseString();
        if (pcodeText == null) {
            return;
        }
        PcodeParser parser = new PcodeParser(this.language, this.uniqueBase);
        Location loc = new Location(sourceName, 1);
        for (InjectPayload.InjectParameter element : input = payload.getInput()) {
            parser.addOperand(loc, element.getName(), element.getIndex());
        }
        for (InjectPayload.InjectParameter element : output = payload.getOutput()) {
            parser.addOperand(loc, element.getName(), element.getIndex());
        }
        ConstructTpl constructTpl = parser.compilePcode(pcodeText, sourceName, 1);
        this.uniqueBase = parser.getNextTempOffset();
        payloadSleigh.setTemplate(constructTpl);
    }

    public String[] getCallFixupNames() {
        Set<String> keySet = this.callFixupMap.keySet();
        String[] names = new String[keySet.size()];
        keySet.toArray(names);
        return names;
    }

    public String[] getCallotherFixupNames() {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<String, InjectPayload> entry : this.callOtherFixupMap.entrySet()) {
            if (entry.getValue() == null) continue;
            list.add(entry.getKey());
        }
        String[] res = new String[list.size()];
        list.toArray(res);
        return res;
    }

    public InjectContext buildInjectContext() {
        InjectContext res = new InjectContext();
        res.language = this.language;
        return res;
    }

    public boolean hasUserDefinedOp(String name) {
        if (this.callOtherFixupMap.size() == 0) {
            int max = this.language.getNumberOfUserDefinedOpNames();
            for (int i = 0; i < max; ++i) {
                String opname = this.language.getUserDefinedOpName(i);
                this.callOtherFixupMap.put(opname, null);
            }
        }
        return this.callOtherFixupMap.containsKey(name);
    }

    protected void registerInject(InjectPayload payload) {
        this.parseInject(payload);
        switch (payload.getType()) {
            case 1: {
                if (this.callFixupMap.containsKey(payload.getName())) {
                    throw new SleighException("CallFixup registered multiple times: " + payload.getName());
                }
                this.callFixupMap.put(payload.getName(), payload);
                break;
            }
            case 2: {
                if (!this.hasUserDefinedOp(payload.getName())) {
                    throw new SleighException("Unknown callother name in <callotherfixup>: " + payload.getName());
                }
                if (this.callOtherFixupMap.get(payload.getName()) != null) {
                    throw new SleighException("Duplicate <callotherfixup> tag: " + payload.getName());
                }
                this.callOtherFixupMap.put(payload.getName(), payload);
                break;
            }
            case 3: {
                if (this.callMechFixupMap.containsKey(payload.getName())) {
                    throw new SleighException("CallMechanism registered multiple times: " + payload.getName());
                }
                this.callMechFixupMap.put(payload.getName(), payload);
                break;
            }
            case 4: {
                if (this.exePcodeMap.containsKey(payload.getName())) {
                    throw new SleighException("Executable p-code registered multiple times: " + payload.getName());
                }
                this.exePcodeMap.put(payload.getName(), payload);
                break;
            }
            default: {
                throw new SleighException("Unknown p-code inject type");
            }
        }
    }

    protected boolean removeMechanismPayload(String nm) {
        InjectPayload payload = this.callMechFixupMap.remove(nm);
        return payload != null;
    }

    protected void uninstallProgramPayloads() {
        if (this.programPayload != null) {
            for (InjectPayloadSleigh injectPayloadSleigh : this.programPayload) {
                if (injectPayloadSleigh.type == 1) {
                    this.callFixupMap.remove(injectPayloadSleigh.name);
                    continue;
                }
                if (injectPayloadSleigh.type != 2) continue;
                this.callOtherFixupMap.put(injectPayloadSleigh.name, null);
            }
            this.programPayload = null;
            if (this.callOtherOverride != null) {
                for (InjectPayload injectPayload : this.callOtherOverride) {
                    this.callOtherFixupMap.put(injectPayload.getName(), injectPayload);
                }
                this.callOtherOverride = null;
            }
        }
    }

    private void setupOverrides(List<InjectPayloadSleigh> userPayloads) {
        InjectPayload origPayload;
        int count = 0;
        for (InjectPayloadSleigh payload : userPayloads) {
            if (payload.getType() != 2 || (origPayload = this.callOtherFixupMap.get(payload.name)) == null) continue;
            ++count;
        }
        if (count == 0) {
            return;
        }
        this.callOtherOverride = new InjectPayload[count];
        count = 0;
        for (InjectPayloadSleigh payload : userPayloads) {
            if (payload.getType() != 2 || (origPayload = this.callOtherFixupMap.get(payload.name)) == null) continue;
            this.callOtherFixupMap.put(payload.name, null);
            this.callOtherOverride[count] = origPayload;
            ++count;
        }
    }

    protected void registerProgramInject(List<InjectPayloadSleigh> userPayloads) {
        this.uninstallProgramPayloads();
        if (userPayloads.isEmpty()) {
            return;
        }
        this.setupOverrides(userPayloads);
        this.programPayload = new InjectPayloadSleigh[userPayloads.size()];
        int count = 0;
        for (InjectPayloadSleigh payload : userPayloads) {
            try {
                this.registerInject(payload);
                this.programPayload[count] = payload;
                ++count;
            }
            catch (SleighException ex) {
                Msg.warn((Object)this, (Object)("Error installing fixup extension: " + payload.name + ": " + ex.getMessage()));
            }
        }
        if (count != this.programPayload.length) {
            InjectPayloadSleigh[] finalPayloads = new InjectPayloadSleigh[count];
            System.arraycopy(this.programPayload, 0, finalPayloads, 0, count);
            this.programPayload = finalPayloads;
        }
    }

    public InjectPayload allocateInject(String sourceName, String name, int tp) {
        if (tp == 1) {
            return new InjectPayloadCallfixup(sourceName);
        }
        if (tp == 2) {
            return new InjectPayloadCallother(sourceName);
        }
        return new InjectPayloadSleigh(name, tp, sourceName);
    }

    public void encodeCompilerSpec(Encoder encoder) throws IOException {
        for (InjectPayload injectPayload : this.callFixupMap.values()) {
            if (!(injectPayload instanceof InjectPayloadSleigh)) continue;
            ((InjectPayloadSleigh)injectPayload).encode(encoder);
        }
        for (InjectPayload injectPayload : this.callOtherFixupMap.values()) {
            if (!(injectPayload instanceof InjectPayloadSleigh)) continue;
            ((InjectPayloadSleigh)injectPayload).encode(encoder);
        }
        for (InjectPayload injectPayload : this.exePcodeMap.values()) {
            if (!(injectPayload instanceof InjectPayloadSegment) || !injectPayload.getSource().startsWith("cspec")) continue;
            ((InjectPayloadSleigh)injectPayload).encode(encoder);
        }
    }

    public InjectPayload restoreXmlInject(String source, String name, int tp, XmlPullParser parser) throws XmlParseException {
        InjectPayload payload = this.allocateInject(source, name, tp);
        payload.restoreXml(parser, this.language);
        this.registerInject(payload);
        return payload;
    }

    public ConstantPool getConstantPool(Program program) throws IOException {
        return null;
    }

    protected long getUniqueBase() {
        return this.uniqueBase;
    }

    public boolean isEquivalent(PcodeInjectLibrary obj) {
        InjectPayload op2payload;
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (this.callFixupMap.size() != obj.callFixupMap.size()) {
            return false;
        }
        for (Map.Entry<String, InjectPayload> entry : this.callFixupMap.entrySet()) {
            op2payload = obj.callFixupMap.get(entry.getKey());
            if (entry.getValue().isEquivalent(op2payload)) continue;
            return false;
        }
        if (this.callMechFixupMap.size() != obj.callMechFixupMap.size()) {
            return false;
        }
        for (Map.Entry<String, InjectPayload> entry : this.callMechFixupMap.entrySet()) {
            op2payload = obj.callMechFixupMap.get(entry.getKey());
            if (entry.getValue().isEquivalent(op2payload)) continue;
            return false;
        }
        if (this.callOtherFixupMap.size() != obj.callOtherFixupMap.size()) {
            return false;
        }
        for (Map.Entry<String, InjectPayload> entry : this.callOtherFixupMap.entrySet()) {
            op2payload = obj.callOtherFixupMap.get(entry.getKey());
            if (!(entry.getValue() != null && op2payload != null ? !entry.getValue().isEquivalent(op2payload) : entry.getValue() != null || op2payload != null)) continue;
            return false;
        }
        if (this.callOtherOverride != null && obj.callOtherOverride != null) {
            if (this.callOtherOverride.length != obj.callOtherOverride.length) {
                return false;
            }
            for (int i = 0; i < this.callOtherOverride.length; ++i) {
                if (this.callOtherOverride[i].isEquivalent(obj.callOtherOverride[i])) continue;
                return false;
            }
        } else if (this.callOtherOverride != null || obj.callOtherOverride != null) {
            return false;
        }
        if (this.exePcodeMap.size() != obj.exePcodeMap.size()) {
            return false;
        }
        for (Map.Entry<String, InjectPayload> entry : this.exePcodeMap.entrySet()) {
            op2payload = obj.exePcodeMap.get(entry.getKey());
            if (entry.getValue().isEquivalent(op2payload)) continue;
            return false;
        }
        if (this.programPayload != null && obj.programPayload != null) {
            if (this.programPayload.length != obj.programPayload.length) {
                return false;
            }
            for (int i = 0; i < this.programPayload.length; ++i) {
                if (this.programPayload[i].isEquivalent(obj.programPayload[i])) continue;
                return false;
            }
        } else if (this.programPayload != null || obj.programPayload != null) {
            return false;
        }
        return true;
    }
}

