/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.pcode.BlockCondition;
import ghidra.program.model.pcode.BlockCopy;
import ghidra.program.model.pcode.BlockDoWhile;
import ghidra.program.model.pcode.BlockGoto;
import ghidra.program.model.pcode.BlockGraph;
import ghidra.program.model.pcode.BlockIfElse;
import ghidra.program.model.pcode.BlockIfGoto;
import ghidra.program.model.pcode.BlockInfLoop;
import ghidra.program.model.pcode.BlockList;
import ghidra.program.model.pcode.BlockMultiGoto;
import ghidra.program.model.pcode.BlockProperIf;
import ghidra.program.model.pcode.BlockSwitch;
import ghidra.program.model.pcode.BlockWhileDo;
import ghidra.program.model.pcode.PcodeBlock;
import ghidra.program.model.pcode.PcodeBlockBasic;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class BlockMap {
    private AddressFactory factory;
    private ArrayList<PcodeBlock> sortlist;
    private ArrayList<PcodeBlock> leaflist;
    private ArrayList<GotoReference> gotoreflist;

    public BlockMap(AddressFactory fac) {
        this.factory = fac;
        this.leaflist = new ArrayList();
        this.gotoreflist = new ArrayList();
        this.sortlist = new ArrayList();
    }

    public BlockMap(BlockMap op2) {
        this.factory = op2.factory;
        this.leaflist = op2.leaflist;
        this.gotoreflist = op2.gotoreflist;
        this.sortlist = new ArrayList();
    }

    public AddressFactory getAddressFactory() {
        return this.factory;
    }

    private static void sortList(ArrayList<PcodeBlock> list) {
        Comparator<PcodeBlock> comp = new Comparator<PcodeBlock>(){

            @Override
            public int compare(PcodeBlock o1, PcodeBlock o2) {
                return o1.index - o2.index;
            }
        };
        Collections.sort(list, comp);
    }

    private static PcodeBlock resolveBlock(int btype) {
        switch (btype) {
            case 1: {
                return new PcodeBlockBasic();
            }
            case 7: {
                return new BlockCondition();
            }
            case 3: {
                return new BlockCopy();
            }
            case 12: {
                return new BlockDoWhile();
            }
            case 4: {
                return new BlockGoto();
            }
            case 2: {
                return new BlockGraph();
            }
            case 9: {
                return new BlockIfElse();
            }
            case 10: {
                return new BlockIfGoto();
            }
            case 14: {
                return new BlockInfLoop();
            }
            case 6: {
                return new BlockList();
            }
            case 5: {
                return new BlockMultiGoto();
            }
            case 0: {
                return new PcodeBlock();
            }
            case 8: {
                return new BlockProperIf();
            }
            case 13: {
                return new BlockSwitch();
            }
            case 11: {
                return new BlockWhileDo();
            }
        }
        return null;
    }

    public PcodeBlock findLevelBlock(int ind) {
        return BlockMap.findBlock(this.sortlist, ind);
    }

    public void sortLevelList() {
        BlockMap.sortList(this.sortlist);
    }

    private static PcodeBlock findBlock(ArrayList<PcodeBlock> list, int ind) {
        int min = 0;
        int max = list.size() - 1;
        while (min <= max) {
            int mid = (min + max) / 2;
            PcodeBlock block = list.get(mid);
            if (block.getIndex() == ind) {
                return block;
            }
            if (block.getIndex() < ind) {
                min = mid + 1;
                continue;
            }
            max = mid - 1;
        }
        return null;
    }

    public PcodeBlock createBlock(String name, int index) {
        int btype = PcodeBlock.nameToType(name);
        PcodeBlock res = BlockMap.resolveBlock(btype);
        res.setIndex(index);
        this.sortlist.add(res);
        if (btype == 0 || btype == 3 || btype == 1) {
            this.leaflist.add(res);
        }
        return res;
    }

    public void addGotoRef(PcodeBlock gblock, int root, int depth) {
        GotoReference ref = new GotoReference(gblock, root, depth);
        this.gotoreflist.add(ref);
    }

    public void resolveGotoReferences() {
        BlockMap.sortList(this.leaflist);
        for (int i = 0; i < this.gotoreflist.size(); ++i) {
            BlockGraph gotoblock;
            GotoReference gotoref = this.gotoreflist.get(i);
            PcodeBlock bl = BlockMap.findBlock(this.leaflist, gotoref.rootindex);
            int depth = gotoref.depth;
            while (depth > 0) {
                --depth;
                bl = bl.getParent();
            }
            if (gotoref.gotoblock instanceof BlockGoto) {
                gotoblock = (BlockGoto)gotoref.gotoblock;
                ((BlockGoto)gotoblock).setGotoTarget(bl);
                continue;
            }
            if (gotoref.gotoblock instanceof BlockIfGoto) {
                gotoblock = (BlockIfGoto)gotoref.gotoblock;
                ((BlockIfGoto)gotoblock).setGotoTarget(bl);
                continue;
            }
            if (!(gotoref.gotoblock instanceof BlockMultiGoto)) continue;
            gotoblock = (BlockMultiGoto)gotoref.gotoblock;
            gotoblock.addBlock(bl);
        }
    }

    private static class GotoReference {
        public PcodeBlock gotoblock;
        public int rootindex;
        public int depth;

        public GotoReference(PcodeBlock gblock, int root, int d) {
            this.gotoblock = gblock;
            this.rootindex = root;
            this.depth = d;
        }
    }
}

