/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.gzip;

import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.file.formats.gzip.GZipConstants;
import ghidra.program.model.listing.Program;
import java.util.Arrays;

public class GZipUtil {
    public static final boolean isGZip(Program program) {
        MemoryByteProvider provider = MemoryByteProvider.createDefaultAddressSpaceByteProvider((Program)program, (boolean)true);
        return GZipUtil.isGZip((ByteProvider)provider);
    }

    public static final boolean isGZip(ByteProvider provider) {
        try {
            byte[] bytes = provider.readBytes(0L, (long)GZipConstants.MAGIC_BYTES.length);
            return Arrays.equals(bytes, GZipConstants.MAGIC_BYTES);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static final boolean isGZip(byte[] bytes) {
        if (bytes.length >= GZipConstants.MAGIC_BYTES.length) {
            return bytes[0] == GZipConstants.MAGIC_BYTES[0] && bytes[1] == GZipConstants.MAGIC_BYTES[1];
        }
        return false;
    }
}

