/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.map;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.EmptyAddressRangeIterator;
import ghidra.trace.database.map.DBTraceAddressSnapRangePropertyMapTree;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.util.AbstractAddressSetView;
import ghidra.util.LockHold;
import ghidra.util.UnionAddressRangeIterator;
import ghidra.util.database.spatial.SpatialMap;
import ghidra.util.database.spatial.rect.Rectangle2DDirection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.function.Predicate;
import org.apache.commons.collections4.IteratorUtils;

public class DBTraceAddressSnapRangePropertyMapAddressSetView<T>
extends AbstractAddressSetView {
    private final AddressRangeImpl fullSpace;
    private final ReadWriteLock lock;
    private final SpatialMap<TraceAddressSnapRange, T, DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery> map;
    private final Predicate<? super T> predicate;

    public DBTraceAddressSnapRangePropertyMapAddressSetView(AddressSpace space, ReadWriteLock lock, SpatialMap<TraceAddressSnapRange, T, DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery> map, Predicate<? super T> predicate) {
        this.fullSpace = new AddressRangeImpl(space.getMinAddress(), space.getMaxAddress());
        this.lock = lock;
        this.map = map;
        this.predicate = predicate;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean contains(Address addr) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            for (Object t : this.map.reduce((Object)DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.intersecting(addr, addr, Long.MIN_VALUE, Long.MAX_VALUE)).values()) {
                if (!this.predicate.test(t)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public boolean contains(Address start, Address end) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            boolean bl = super.contains(start, end);
            return bl;
        }
    }

    public boolean contains(AddressSetView rangeSet) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            boolean bl = super.contains(rangeSet);
            return bl;
        }
    }

    public boolean isEmpty() {
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            for (Object t : this.map.values()) {
                if (!this.predicate.test(t)) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
    }

    public Address getMinAddress() {
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            for (Map.Entry entry : this.map.reduce((Object)((DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery)DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.intersecting((AddressRange)this.fullSpace, Lifespan.ALL).starting(Rectangle2DDirection.LEFTMOST))).orderedEntries()) {
                if (!this.predicate.test(entry.getValue())) continue;
                Address address = ((TraceAddressSnapRange)entry.getKey()).getX1();
                return address;
            }
        }
        return null;
    }

    public Address getMaxAddress() {
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            for (Map.Entry entry : this.map.reduce((Object)((DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery)DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.intersecting((AddressRange)this.fullSpace, Lifespan.ALL).starting(Rectangle2DDirection.RIGHTMOST))).orderedEntries()) {
                if (!this.predicate.test(entry.getValue())) continue;
                Address address = ((TraceAddressSnapRange)entry.getKey()).getX2();
                return address;
            }
        }
        return null;
    }

    public int getNumAddressRanges() {
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            int n = super.getNumAddressRanges();
            return n;
        }
    }

    public AddressRangeIterator getAddressRanges() {
        return this.getAddressRanges(this.fullSpace.getMinAddress(), true);
    }

    public AddressRangeIterator getAddressRanges(boolean forward) {
        return this.getAddressRanges(forward ? this.fullSpace.getMinAddress() : this.fullSpace.getMaxAddress(), forward);
    }

    public AddressRangeIterator getAddressRanges(Address start, boolean forward) {
        if (!start.getAddressSpace().equals((Object)this.fullSpace.getMinAddress().getAddressSpace())) {
            return new EmptyAddressRangeIterator();
        }
        AddressRangeImpl within = forward ? new AddressRangeImpl(start, this.fullSpace.getMaxAddress()) : new AddressRangeImpl(this.fullSpace.getMinAddress(), start);
        Iterator mapIt = this.map.reduce((Object)((DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery)DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.intersecting((AddressRange)within, Lifespan.ALL).starting(forward ? Rectangle2DDirection.LEFTMOST : Rectangle2DDirection.RIGHTMOST))).orderedEntries().iterator();
        Iterator fltIt = IteratorUtils.filteredIterator(mapIt, e -> this.predicate.test(e.getValue()));
        Iterator rawIt = IteratorUtils.transformedIterator((Iterator)fltIt, e -> ((TraceAddressSnapRange)e.getKey()).getRange());
        return new UnionAddressRangeIterator(rawIt, forward);
    }

    public long getNumAddresses() {
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            long l = super.getNumAddresses();
            return l;
        }
    }

    public boolean intersects(AddressSetView addrSet) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            boolean bl = super.intersects(addrSet);
            return bl;
        }
    }

    public boolean intersects(Address start, Address end) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            boolean bl = super.intersects(start, end);
            return bl;
        }
    }

    public AddressSet intersect(AddressSetView view) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            AddressSet addressSet = super.intersect(view);
            return addressSet;
        }
    }

    public AddressSet intersectRange(Address start, Address end) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            AddressSet addressSet = super.intersectRange(start, end);
            return addressSet;
        }
    }

    public AddressSet union(AddressSetView addrSet) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            AddressSet addressSet = super.union(addrSet);
            return addressSet;
        }
    }

    public AddressSet subtract(AddressSetView addrSet) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            AddressSet addressSet = super.subtract(addrSet);
            return addressSet;
        }
    }

    public AddressSet xor(AddressSetView addrSet) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            AddressSet addressSet = super.xor(addrSet);
            return addressSet;
        }
    }

    public boolean hasSameAddresses(AddressSetView view) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            boolean bl = super.hasSameAddresses(view);
            return bl;
        }
    }

    public AddressRange getFirstRange() {
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            AddressRange addressRange = super.getFirstRange();
            return addressRange;
        }
    }

    public AddressRange getLastRange() {
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            AddressRange addressRange = super.getLastRange();
            return addressRange;
        }
    }

    public AddressRange getRangeContaining(Address address) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            AddressRange addressRange = super.getRangeContaining(address);
            return addressRange;
        }
    }

    public Address findFirstAddressInCommon(AddressSetView set) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            Address address = super.findFirstAddressInCommon(set);
            return address;
        }
    }
}

