/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.module;

import db.DBRecord;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSpace;
import ghidra.trace.database.DBTrace;
import ghidra.trace.database.DBTraceUtils;
import ghidra.trace.database.map.DBTraceAddressSnapRangePropertyMapTree;
import ghidra.trace.database.module.DBTraceModuleSpace;
import ghidra.trace.database.module.DBTraceSection;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.modules.TraceModule;
import ghidra.trace.model.modules.TraceSection;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.trace.util.TraceEvents;
import ghidra.util.LockHold;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DBObjectColumn;
import ghidra.util.database.annot.DBAnnotatedColumn;
import ghidra.util.database.annot.DBAnnotatedField;
import ghidra.util.database.annot.DBAnnotatedObjectInfo;
import ghidra.util.exception.DuplicateNameException;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.locks.Lock;

@DBAnnotatedObjectInfo(version=0)
public class DBTraceModule
extends DBTraceAddressSnapRangePropertyMapTree.AbstractDBTraceAddressSnapRangePropertyMapData<DBTraceModule>
implements TraceModule {
    static final String TABLE_NAME = "Modules";
    static final String PATH_COLUMN_NAME = "Path";
    static final String NAME_COLUMN_NAME = "Name";
    @DBAnnotatedColumn(value="Path")
    static DBObjectColumn PATH_COLUMN;
    @DBAnnotatedColumn(value="Name")
    static DBObjectColumn NAME_COLUMN;
    @DBAnnotatedField(column="Path", indexed=true)
    String path;
    @DBAnnotatedField(column="Name")
    String name;
    final DBTraceModuleSpace space;

    static String tableName(AddressSpace space) {
        return DBTraceUtils.tableName(TABLE_NAME, space, -1L, 0);
    }

    public DBTraceModule(DBTraceModuleSpace space, DBTraceAddressSnapRangePropertyMapTree<DBTraceModule, ?> tree, DBCachedObjectStore<?> store, DBRecord record) {
        super(tree, store, record);
        this.space = space;
    }

    protected void setRecordValue(DBTraceModule value) {
    }

    protected DBTraceModule getRecordValue() {
        return this;
    }

    void set(String path, String name) {
        this.path = path;
        this.name = name;
        this.update(PATH_COLUMN, NAME_COLUMN);
    }

    @Override
    public DBTrace getTrace() {
        return this.space.trace;
    }

    @Override
    public DBTraceSection addSection(long snap, String sectionPath, String sectionName, AddressRange range) throws DuplicateNameException {
        try (LockHold hold = LockHold.lock((Lock)this.space.manager.writeLock());){
            DBTraceSection dBTraceSection = this.space.manager.doAddSection(this, sectionPath, sectionName, range);
            return dBTraceSection;
        }
    }

    @Override
    public String getPath() {
        try (LockHold hold = LockHold.lock((Lock)this.space.manager.readLock());){
            String string = this.path;
            return string;
        }
    }

    @Override
    public void setName(long snap, String name) {
        try (LockHold hold = LockHold.lock((Lock)this.space.manager.writeLock());){
            if (Objects.equals(this.name, name)) {
                return;
            }
            this.name = name;
            this.update(NAME_COLUMN);
        }
        this.space.trace.setChanged(new TraceChangeRecord<DBTraceModule, Void>(TraceEvents.MODULE_CHANGED, null, this));
    }

    @Override
    public String getName(long snap) {
        try (LockHold hold = LockHold.lock((Lock)this.space.manager.readLock());){
            String string = this.name;
            return string;
        }
    }

    @Override
    public void setRange(long snap, AddressRange range) {
        try (LockHold hold = LockHold.lock((Lock)this.space.manager.writeLock());){
            if (this.range.equals((Object)range)) {
                return;
            }
            this.doSetRange(range);
        }
        this.space.trace.setChanged(new TraceChangeRecord<DBTraceModule, Void>(TraceEvents.MODULE_CHANGED, this.space, this));
    }

    @Override
    public AddressRange getRange(long snap) {
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.readLock());){
            AddressRange addressRange = this.range;
            return addressRange;
        }
    }

    @Override
    public void setBase(long snap, Address base) {
        try (LockHold hold = LockHold.lock((Lock)this.space.manager.writeLock());){
            this.setRange(snap, DBTraceUtils.toRange(base, this.range.getMaxAddress()));
        }
    }

    @Override
    public Address getBase(long snap) {
        try (LockHold hold = LockHold.lock((Lock)this.space.manager.readLock());){
            Address address = this.range.getMinAddress();
            return address;
        }
    }

    @Override
    public void setMaxAddress(long snap, Address max) {
        try (LockHold hold = LockHold.lock((Lock)this.space.manager.writeLock());){
            this.setRange(snap, DBTraceUtils.toRange(this.range.getMinAddress(), max));
        }
    }

    @Override
    public Address getMaxAddress(long snap) {
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.readLock());){
            Address address = this.range.getMaxAddress();
            return address;
        }
    }

    @Override
    public void setLength(long snap, long length) throws AddressOverflowException {
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.writeLock());){
            Address base = this.range.getMinAddress();
            this.setRange(snap, DBTraceUtils.toRange(base, base.addNoWrap(length - 1L)));
        }
    }

    @Override
    public long getLength(long snap) {
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.readLock());){
            long l = this.range.getLength();
            return l;
        }
    }

    public Collection<? extends DBTraceSection> getSections(long snap) {
        return this.getAllSections();
    }

    public Collection<? extends DBTraceSection> getAllSections() {
        return this.space.manager.doGetSectionsByModuleId(this.getKey());
    }

    @Override
    public TraceSection getSectionByName(long snap, String sectionName) {
        return this.space.manager.doGetSectionByName(this.getKey(), sectionName);
    }

    @Override
    public void delete() {
        this.space.manager.doDeleteModule(this);
    }

    @Override
    public void remove(long snap) {
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.writeLock());){
            if (snap <= this.lifespan.lmin()) {
                this.space.manager.doDeleteModule(this);
            } else if (snap <= this.lifespan.lmax()) {
                this.doSetLifespan(this.lifespan.withMax(snap - 1L));
            }
        }
    }

    @Override
    public boolean isValid(long snap) {
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.readLock());){
            boolean bl = this.lifespan.contains(snap);
            return bl;
        }
    }

    @Override
    public boolean isAlive(Lifespan span) {
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.readLock());){
            boolean bl = this.lifespan.intersects(span);
            return bl;
        }
    }
}

