/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.time;

import db.DBRecord;
import ghidra.trace.database.target.DBTraceObject;
import ghidra.trace.database.time.DBTraceTimeManager;
import ghidra.trace.model.Trace;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.TraceObjectValue;
import ghidra.trace.model.target.iface.TraceObjectEventScope;
import ghidra.trace.model.thread.TraceObjectThread;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.model.time.TraceSnapshot;
import ghidra.trace.model.time.schedule.TraceSchedule;
import ghidra.util.LockHold;
import ghidra.util.Msg;
import ghidra.util.database.DBAnnotatedObject;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DBObjectColumn;
import ghidra.util.database.annot.DBAnnotatedColumn;
import ghidra.util.database.annot.DBAnnotatedField;
import ghidra.util.database.annot.DBAnnotatedObjectInfo;
import java.io.IOException;
import java.util.concurrent.locks.Lock;

@DBAnnotatedObjectInfo(version=0)
public class DBTraceSnapshot
extends DBAnnotatedObject
implements TraceSnapshot {
    protected static final String TABLE_NAME = "Snapshots";
    protected static final String REAL_TIME_COLUMN_NAME = "RealTime";
    protected static final String SCHEDULE_COLUMN_NAME = "Schedule";
    protected static final String VERSION_COLUMN_NAME = "Version";
    protected static final String DESCRIPTION_COLUMN_NAME = "Description";
    protected static final String THREAD_COLUMN_NAME = "Thread";
    @DBAnnotatedColumn(value="RealTime")
    static DBObjectColumn REAL_TIME_COLUMN;
    @DBAnnotatedColumn(value="Schedule")
    static DBObjectColumn SCHEDULE_COLUMN;
    @DBAnnotatedColumn(value="Version")
    static DBObjectColumn VERSION_COLUMN;
    @DBAnnotatedColumn(value="Description")
    static DBObjectColumn DESCRIPTION_COLUMN;
    @DBAnnotatedColumn(value="Thread")
    static DBObjectColumn THREAD_COLUMN;
    @DBAnnotatedField(column="RealTime")
    long realTime;
    @DBAnnotatedField(column="Schedule", indexed=true)
    String scheduleStr = "";
    @DBAnnotatedField(column="Version")
    long version;
    @DBAnnotatedField(column="Description")
    String description;
    @DBAnnotatedField(column="Thread")
    long threadKey = -1L;
    public final DBTraceTimeManager manager;
    private TraceThread eventThread;
    private TraceSchedule schedule;

    public DBTraceSnapshot(DBTraceTimeManager manager, DBCachedObjectStore<?> store, DBRecord record) {
        super(store, record);
        this.manager = manager;
    }

    protected void fresh(boolean created) throws IOException {
        if (created) {
            this.threadKey = -1L;
            this.scheduleStr = "";
        } else {
            this.eventThread = this.manager.threadManager.getThread(this.threadKey);
            if (!"".equals(this.scheduleStr)) {
                try {
                    this.schedule = TraceSchedule.parse(this.scheduleStr, TraceSchedule.TimeRadix.DEC);
                }
                catch (IllegalArgumentException e) {
                    Msg.error((Object)this, (Object)("Could not parse schedule: " + String.valueOf(this.schedule)), (Throwable)e);
                }
            }
        }
    }

    public String toString() {
        return String.format("<DBTraceSnapshot key=%d, realTime=%d, schedule='%s', description='%s'>", this.key, this.realTime, this.scheduleStr, this.description);
    }

    protected void set(long realTime, String description) {
        this.realTime = realTime;
        this.description = description;
        this.update(REAL_TIME_COLUMN, DESCRIPTION_COLUMN);
    }

    @Override
    public Trace getTrace() {
        return this.manager.trace;
    }

    @Override
    public long getRealTime() {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            long l = this.realTime;
            return l;
        }
    }

    @Override
    public void setRealTime(long millis) {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
            this.realTime = millis;
            this.update(REAL_TIME_COLUMN);
            this.manager.notifySnapshotChanged(this);
        }
    }

    @Override
    public String getDescription() {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            String string = this.description;
            return string;
        }
    }

    @Override
    public void setDescription(String description) {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
            this.description = description;
            this.update(DESCRIPTION_COLUMN);
            this.manager.notifySnapshotChanged(this);
        }
    }

    @Override
    public TraceThread getEventThread() {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            if (this.eventThread != null) {
                TraceThread traceThread = this.eventThread;
                return traceThread;
            }
            DBTraceObject root = this.manager.trace.getObjectManager().getRootObject();
            if (root == null) {
                TraceThread traceThread = null;
                return traceThread;
            }
            if (!root.getSchema().getInterfaces().contains(TraceObjectEventScope.class)) {
                TraceThread traceThread = null;
                return traceThread;
            }
            TraceObjectValue eventAttr = root.getAttribute(this.getKey(), "_event_thread");
            if (eventAttr == null) {
                TraceThread traceThread = null;
                return traceThread;
            }
            Object object = eventAttr.getValue();
            if (!(object instanceof TraceObject)) {
                object = null;
                return object;
            }
            TraceObject eventObj = (TraceObject)object;
            object = eventObj.queryInterface(TraceObjectThread.class);
            return object;
        }
    }

    @Override
    public void setEventThread(TraceThread thread) {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
            if (thread == null) {
                this.eventThread = null;
                this.threadKey = -1L;
            } else {
                this.eventThread = this.manager.threadManager.assertIsMine(thread);
                this.threadKey = thread.getKey();
            }
            this.update(THREAD_COLUMN);
            this.manager.notifySnapshotChanged(this);
        }
    }

    @Override
    public TraceSchedule getSchedule() {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            TraceSchedule traceSchedule = this.schedule;
            return traceSchedule;
        }
    }

    @Override
    public String getScheduleString() {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            String string = this.scheduleStr;
            return string;
        }
    }

    @Override
    public void setSchedule(TraceSchedule schedule) {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
            this.schedule = schedule;
            this.scheduleStr = schedule == null ? "" : schedule.toString(TraceSchedule.TimeRadix.DEC);
            this.update(SCHEDULE_COLUMN);
            this.manager.notifySnapshotChanged(this);
        }
    }

    @Override
    public long getVersion() {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            long l = this.version;
            return l;
        }
    }

    @Override
    public void setVersion(long version) {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
            this.version = version;
            this.update(VERSION_COLUMN);
            this.manager.notifySnapshotChanged(this);
        }
    }

    @Override
    public void delete() {
        this.manager.deleteSnapshot(this);
    }
}

