/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model;

import ghidra.program.model.address.Address;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceLocation;
import ghidra.trace.model.thread.TraceThread;
import java.util.Objects;

public class DefaultTraceLocation
implements TraceLocation {
    private final Trace trace;
    private final TraceThread thread;
    private final Lifespan lifespan;
    private final Address address;

    public DefaultTraceLocation(Trace trace, TraceThread thread, Lifespan lifespan, Address address) {
        this.trace = trace;
        this.thread = thread;
        this.lifespan = lifespan;
        this.address = address;
    }

    @Override
    public Trace getTrace() {
        return this.trace;
    }

    @Override
    public TraceThread getThread() {
        return this.thread;
    }

    @Override
    public Lifespan getLifespan() {
        return this.lifespan;
    }

    @Override
    public Address getAddress() {
        return this.address;
    }

    public String toString() {
        return "TraceLocation<" + String.valueOf(this.trace) + ": " + String.valueOf(this.lifespan) + "," + String.valueOf(this.address) + ">";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DefaultTraceLocation)) {
            return false;
        }
        DefaultTraceLocation that = (DefaultTraceLocation)obj;
        if (this.trace != that.trace) {
            return false;
        }
        if (this.thread != that.thread) {
            return false;
        }
        if (!Objects.equals(this.address, that.address)) {
            return false;
        }
        return Objects.equals(this.lifespan, that.lifespan);
    }

    public int hashCode() {
        return Objects.hash(this.trace, this.thread, this.lifespan, this.address);
    }

    @Override
    public int compareTo(TraceLocation that) {
        if (this == that) {
            return 0;
        }
        int result = this.trace.getName().compareTo(that.getTrace().getName());
        if (result != 0) {
            return result;
        }
        result = this.thread.getName(this.lifespan.lmin()).compareTo(that.getThread().getName(this.lifespan.lmin()));
        if (result != 0) {
            return result;
        }
        result = this.getLifespan().compareTo(that.getLifespan());
        if (result != 0) {
            return result;
        }
        result = this.address.compareTo((Object)that.getAddress());
        if (result != 0) {
            return result;
        }
        return 0;
    }
}

