/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.trace.model.ImmutableTraceAddressSnapRange;
import ghidra.trace.model.Lifespan;
import ghidra.util.database.spatial.rect.Rectangle2D;

public interface TraceAddressSnapRange
extends Rectangle2D<Address, Long, TraceAddressSnapRange> {
    public Lifespan getLifespan();

    public AddressRange getRange();

    default public TraceAddressSnapRange getBounds() {
        return this;
    }

    default public Address getX1() {
        return this.getRange().getMinAddress();
    }

    default public Address getX2() {
        return this.getRange().getMaxAddress();
    }

    default public Long getY1() {
        return (Long)this.getLifespan().min();
    }

    default public Long getY2() {
        return (Long)this.getLifespan().max();
    }

    default public TraceAddressSnapRange immutable(Address x1, Address x2, Long y1, Long y2) {
        return new ImmutableTraceAddressSnapRange(x1, x2, y1, y2);
    }

    default public String description() {
        return String.format("[%s:%x:%x]%s", this.getRange().getAddressSpace(), this.getX1().getOffset(), this.getX2().getOffset(), this.getLifespan());
    }
}

