/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets;

import java.awt.event.KeyEvent;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;

public abstract class AutoLookup {
    public static final long KEY_TYPING_TIMEOUT = 800L;
    private static final int MAX_SEARCH_ROWS = 50000;
    private long keyTimeout = 800L;
    private Predicate<Long> keyTimeoutPredicate = elapsedTime -> elapsedTime > this.keyTimeout;
    private AutoLookupItem lastLookup;
    private int lookupColumn = 0;

    public abstract int getCurrentRow();

    public abstract int getRowCount();

    public abstract String getValueString(int var1, int var2);

    public abstract boolean isSorted(int var1);

    protected boolean canBinarySearchColumn(int column) {
        return this.isSorted(column);
    }

    public abstract boolean isSortedAscending();

    public abstract void matchFound(int var1);

    public void setTimeout(long timeout) {
        this.keyTimeout = timeout;
        this.lastLookup = null;
    }

    public void setColumn(int column) {
        this.lookupColumn = column;
        this.lastLookup = null;
    }

    public void setTimeoutPredicate(Predicate<Long> p) {
        this.keyTimeoutPredicate = p;
    }

    public void keyTyped(KeyEvent e) {
        if (this.getRowCount() == 0) {
            return;
        }
        AutoLookupItem lookup = this.lastLookup;
        if (lookup == null) {
            lookup = new AutoLookupItem();
        }
        lookup.keyTyped(e);
        if (lookup.shouldSkip()) {
            return;
        }
        int row = this.lookupText(lookup.getText());
        lookup.setFoundMatch(row >= 0);
        if (row >= 0) {
            this.matchFound(row);
        }
        this.lastLookup = lookup;
    }

    private int lookupText(String text) {
        if (text == null) {
            return -1;
        }
        int row = this.getCurrentRow();
        if (row >= 0 && row < this.getRowCount() - 1) {
            int col;
            if (text.length() == 1) {
                ++row;
            }
            if (this.textMatches(text, row, col = this.lookupColumn)) {
                return row;
            }
        }
        if (this.canBinarySearchColumn(this.lookupColumn)) {
            return this.autoLookupBinary(text);
        }
        return this.autoLookupLinear(text);
    }

    private boolean textMatches(String text, int row, int col) {
        String value = this.getValueString(row, col);
        return StringUtils.startsWithIgnoreCase((CharSequence)value, (CharSequence)text);
    }

    private boolean isIgnorableKeyEvent(KeyEvent event) {
        if (!this.isUnmodifiedOrShift(event.getModifiersEx())) {
            return true;
        }
        return event.isActionKey() || event.getKeyChar() == '\uffff' || Character.isISOControl(event.getKeyChar());
    }

    private boolean isUnmodifiedOrShift(int modifiers) {
        if (modifiers == 0) {
            return true;
        }
        int shift = 64;
        return (modifiers | shift) != shift;
    }

    private int autoLookupLinear(String text) {
        int i;
        int max = 50000;
        int rows = this.getRowCount();
        int start = this.getCurrentRow();
        int counter = 0;
        int col = this.lookupColumn;
        for (i = start + 1; i < rows && counter < max; ++i, ++counter) {
            if (!this.textMatches(text, i, col)) continue;
            return i;
        }
        for (i = 0; i < start && counter < max; ++i, ++counter) {
            if (!this.textMatches(text, i, col)) continue;
            return i;
        }
        return -1;
    }

    private int autoLookupBinary(String text) {
        int col;
        int index = this.binarySearch(text);
        if (this.textMatches(text, index, col = this.lookupColumn)) {
            return index;
        }
        if (index - 1 >= 0 && this.textMatches(text, index - 1, col)) {
            return index - 1;
        }
        if (index + 1 < this.getRowCount() && this.textMatches(text, index + 1, col)) {
            return index + 1;
        }
        return -1;
    }

    private int binarySearch(String text) {
        int sortedOrder = 1;
        if (!this.isSortedAscending()) {
            sortedOrder = -1;
            int lastPos = ((String)text).length() - 1;
            char lastChar = ((String)text).charAt(lastPos);
            lastChar = (char)(lastChar + '\u0001');
            text = ((String)text).substring(0, lastPos) + lastChar;
        }
        int min = 0;
        int rows = this.getRowCount();
        int max = rows - 1;
        int col = this.lookupColumn;
        while (min < max) {
            int mid = min + max >>> 1;
            String value = this.getValueString(mid, col);
            int compare = ((String)text).compareToIgnoreCase(value);
            if ((compare *= sortedOrder) < 0) {
                max = mid - 1;
                continue;
            }
            if (compare > 0) {
                min = mid + 1;
                continue;
            }
            return mid;
        }
        return min;
    }

    private class AutoLookupItem {
        private long lastTime;
        private String text;
        private boolean foundPreviousMatch;
        private boolean skip;

        private AutoLookupItem() {
        }

        void keyTyped(KeyEvent e) {
            this.skip = false;
            if (AutoLookup.this.isIgnorableKeyEvent(e)) {
                this.skip = true;
                return;
            }
            String eventChar = Character.toString(e.getKeyChar());
            long when = e.getWhen();
            long elapsed = when - this.lastTime;
            boolean didTimeout = AutoLookup.this.keyTimeoutPredicate.test(elapsed);
            if (didTimeout) {
                this.text = eventChar;
            } else {
                this.text = this.text + eventChar;
                if (!this.foundPreviousMatch) {
                    this.skip = true;
                    when = this.lastTime;
                }
            }
            this.lastTime = when;
        }

        void setFoundMatch(boolean foundMatch) {
            this.foundPreviousMatch = foundMatch;
        }

        String getText() {
            return this.text;
        }

        boolean shouldSkip() {
            return this.skip;
        }
    }
}

