/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.algorithms.eiglsperger;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.LongSummaryStatistics;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jgrapht.Graph;
import org.jgrapht.alg.util.NeighborCache;
import org.jungrapht.visualization.layout.algorithms.Layered;
import org.jungrapht.visualization.layout.algorithms.eiglsperger.EiglspergerRunnable;
import org.jungrapht.visualization.layout.algorithms.eiglsperger.EiglspergerStepsBackward;
import org.jungrapht.visualization.layout.algorithms.eiglsperger.EiglspergerStepsForward;
import org.jungrapht.visualization.layout.algorithms.eiglsperger.SelectiveEiglspergerHorizontalCoordinateAssignment;
import org.jungrapht.visualization.layout.algorithms.eiglsperger.SyntheticLV;
import org.jungrapht.visualization.layout.algorithms.eiglsperger.Synthetics;
import org.jungrapht.visualization.layout.algorithms.sugiyama.ArticulatedEdge;
import org.jungrapht.visualization.layout.algorithms.sugiyama.ConstructiveFeedbackArcFunction;
import org.jungrapht.visualization.layout.algorithms.sugiyama.GraphLayers;
import org.jungrapht.visualization.layout.algorithms.sugiyama.GreedyFeedbackArcFunction;
import org.jungrapht.visualization.layout.algorithms.sugiyama.LE;
import org.jungrapht.visualization.layout.algorithms.sugiyama.LV;
import org.jungrapht.visualization.layout.algorithms.sugiyama.TransformedGraphSupplier;
import org.jungrapht.visualization.layout.algorithms.sugiyama.Unaligned;
import org.jungrapht.visualization.layout.model.Point;
import org.jungrapht.visualization.layout.model.Rectangle;
import org.jungrapht.visualization.layout.util.PropertyLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendedEiglspergerRunnable<V, E>
extends EiglspergerRunnable<V, E>
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(ExtendedEiglspergerRunnable.class);
    boolean doUpLeft;
    boolean doDownLeft;
    boolean doUpRight;
    boolean doDownRight;

    public static <V, E> Builder<V, E, ?, ?> builder() {
        return new Builder();
    }

    protected ExtendedEiglspergerRunnable(Builder<V, E, ?, ?> builder) {
        super(builder);
        this.doUpLeft = builder.doUpLeft;
        this.doDownLeft = builder.doDownLeft;
        this.doUpRight = builder.doUpRight;
        this.doDownRight = builder.doDownRight;
    }

    @Override
    public void run() {
        int n;
        int n2;
        List layers;
        Collection feedbacks;
        this.graph = this.layoutModel.getGraph();
        if (this.graph.vertexSet().isEmpty()) {
            return;
        }
        if (this.graph.vertexSet().size() == 1) {
            Object v2 = this.graph.vertexSet().stream().findFirst().get();
            this.layoutModel.setSize(50, this.layoutModel.getHeight());
            this.layoutModel.set(v2, this.layoutModel.getWidth() / 2, this.layoutModel.getHeight() / 2);
            return;
        }
        long startTime = System.currentTimeMillis();
        TransformedGraphSupplier transformedGraphSupplier = new TransformedGraphSupplier(this.graph);
        this.svGraph = transformedGraphSupplier.get();
        this.neighborCache = new NeighborCache(this.svGraph);
        long transformTime = System.currentTimeMillis();
        log.trace("transform Graph took {}", (Object)(transformTime - startTime));
        if (this.edgeComparator == Layered.noopComparator) {
            GreedyFeedbackArcFunction greedyFeedbackArcFunction = new GreedyFeedbackArcFunction();
            feedbacks = greedyFeedbackArcFunction.apply(this.graph);
        } else {
            ConstructiveFeedbackArcFunction constructiveFeedbackArcFunction = new ConstructiveFeedbackArcFunction(this.edgeComparator);
            feedbacks = constructiveFeedbackArcFunction.apply(this.graph);
        }
        Collection feedbackArcs = this.svGraph.edgeSet().stream().filter(e -> feedbacks.contains(e.getEdge())).collect(Collectors.toSet());
        for (LE se : feedbackArcs) {
            this.svGraph.removeEdge((Object)se);
            LE newEdge = LE.of(se.getEdge(), se.getTarget(), se.getSource());
            this.svGraph.addEdge(newEdge.getSource(), newEdge.getTarget(), newEdge);
        }
        long cycles = System.currentTimeMillis();
        log.trace("remove cycles took {}", (Object)(cycles - transformTime));
        if (this.cancelled || Thread.currentThread().isInterrupted()) {
            log.trace("interrupted before layering, cancelled: {}", (Object)this.cancelled);
            return;
        }
        Comparator svComparator = (e1, e2) -> this.edgeComparator.compare(e1.getEdge(), e2.getEdge());
        switch (this.layering) {
            case LONGEST_PATH: {
                if (this.edgeComparator != Layered.noopComparator) {
                    layers = GraphLayers.longestPath(this.svGraph, svComparator);
                    break;
                }
                layers = GraphLayers.longestPath(this.svGraph);
                break;
            }
            case COFFMAN_GRAHAM: {
                if (this.edgeComparator != Layered.noopComparator) {
                    layers = GraphLayers.coffmanGraham(this.svGraph, this.neighborCache, 0, svComparator);
                    break;
                }
                layers = GraphLayers.coffmanGraham(this.svGraph, this.neighborCache, 0);
                break;
            }
            case NETWORK_SIMPLEX: {
                if (this.edgeComparator != Layered.noopComparator) {
                    layers = GraphLayers.networkSimplex(this.svGraph, svComparator);
                    break;
                }
                layers = GraphLayers.networkSimplex(this.svGraph);
                break;
            }
            default: {
                layers = this.edgeComparator != Layered.noopComparator ? GraphLayers.assign(this.svGraph, svComparator) : GraphLayers.assign(this.svGraph);
            }
        }
        if (this.minimizeEdgeLength) {
            GraphLayers.minimizeEdgeLength(this.svGraph, layers);
        }
        long assignLayersTime = System.currentTimeMillis();
        log.trace("assign layers took {} ", (Object)(assignLayersTime - cycles));
        if (log.isTraceEnabled()) {
            GraphLayers.checkLayers(layers);
        }
        Synthetics synthetics = new Synthetics(this.svGraph);
        ArrayList edges = new ArrayList(this.svGraph.edgeSet());
        LV<V>[][] layersArray = synthetics.createVirtualVerticesAndEdges(edges, layers);
        if (log.isTraceEnabled()) {
            GraphLayers.checkLayers(layersArray);
        }
        long syntheticsTime = System.currentTimeMillis();
        log.trace("synthetics took {}", (Object)(syntheticsTime - assignLayersTime));
        if (this.svGraph.edgeSet().size() > 200) {
            this.maxLevelCross = 2;
        }
        this.stepsForward = new EiglspergerStepsForward(this.svGraph, this.neighborCache, layersArray, this.transpose);
        this.stepsBackward = new EiglspergerStepsBackward(this.svGraph, this.neighborCache, layersArray, this.transpose);
        int bestCrossCount = Integer.MAX_VALUE;
        Graph bestCompactionGraph = null;
        for (int i = 0; i < this.maxLevelCross; ++i) {
            Graph compactionGraph;
            int sweepCrossCount;
            if (this.cancelled || Thread.currentThread().isInterrupted()) {
                log.trace("interrupted in level cross, cancelled: {}", (Object)this.cancelled);
                return;
            }
            if (i % 2 == 0) {
                sweepCrossCount = this.stepsForward.sweep(layersArray);
                compactionGraph = this.stepsForward.compactionGraph;
                if (sweepCrossCount < bestCrossCount) {
                    bestCrossCount = sweepCrossCount;
                    this.vertexMetadataMap = this.save(layersArray);
                    bestCompactionGraph = this.copy(compactionGraph);
                    continue;
                }
                if (!log.isTraceEnabled()) continue;
                log.trace("best:{}", layersArray);
                continue;
            }
            sweepCrossCount = this.stepsBackward.sweep(layersArray);
            compactionGraph = this.stepsBackward.compactionGraph;
            if (sweepCrossCount < bestCrossCount) {
                bestCrossCount = sweepCrossCount;
                this.vertexMetadataMap = this.save(layersArray);
                bestCompactionGraph = this.copy(compactionGraph);
                continue;
            }
            if (!log.isTraceEnabled()) continue;
            log.trace("best:{}", layersArray);
        }
        log.trace("bestCrossCount: {}", (Object)bestCrossCount);
        this.restore(layersArray, this.vertexMetadataMap);
        Arrays.stream(layersArray).forEach(layer -> Arrays.sort(layer, Comparator.comparingInt(LV::getIndex)));
        Rectangle avgVertexBounds = ExtendedEiglspergerRunnable.maxVertexBounds(layersArray, this.vertexShapeFunction);
        int horizontalOffset = (int)Math.max(avgVertexBounds.width, (double)Integer.getInteger("jungrapht.mincross.horizontalOffset", 50).intValue());
        int verticalOffset = (int)Math.max(avgVertexBounds.height, (double)Integer.getInteger("jungrapht.mincross.verticalOffset", 50).intValue());
        GraphLayers.checkLayers(layersArray);
        HashMap<LV<V>[], Point> vertexPointMap = new HashMap<LV<V>[], Point>();
        for (LV<V>[] value : layersArray) {
            for (int j = 0; j < value.length; ++j) {
                value[j].setIndex(j);
            }
        }
        if (this.cancelled || Thread.currentThread().isInterrupted()) {
            log.trace("interrupted before compaction, cancelled: {}", (Object)this.cancelled);
            return;
        }
        if (this.straightenEdges) {
            SelectiveEiglspergerHorizontalCoordinateAssignment horizontalCoordinateAssignment = new SelectiveEiglspergerHorizontalCoordinateAssignment(layersArray, this.svGraph, bestCompactionGraph, new HashSet(), horizontalOffset, verticalOffset, this.doUpLeft, this.doUpRight, this.doDownLeft, this.doDownRight);
            horizontalCoordinateAssignment.horizontalCoordinateAssignment();
            GraphLayers.checkLayers(layersArray);
            for (LV<V>[] lvs : layersArray) {
                for (LV<V>[] lVArray : lvs) {
                    vertexPointMap.put(lVArray, lVArray.getPoint());
                }
            }
        } else {
            Unaligned.centerPoints(layersArray, this.vertexShapeFunction, horizontalOffset, verticalOffset);
        }
        HashMap<Integer, Integer> rowWidthMap = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> rowMaxHeightMap = new HashMap<Integer, Integer>();
        int layerIndex = 0;
        int totalHeight = 0;
        int totalWidth = 0;
        for (LV<V>[] lVArray : layersArray) {
            int width = horizontalOffset;
            int maxHeight = 0;
            for (LV<V>[] v3 : lVArray) {
                if (!(v3 instanceof SyntheticLV)) {
                    Rectangle bounds = (Rectangle)this.vertexShapeFunction.apply(v3.getVertex());
                    width = (int)((double)width + (bounds.width + (double)horizontalOffset));
                    maxHeight = Math.max(maxHeight, (int)bounds.height);
                    continue;
                }
                width += horizontalOffset;
            }
            rowWidthMap.put(layerIndex, width);
            rowMaxHeightMap.put(layerIndex, maxHeight);
            ++layerIndex;
        }
        int widestRowWidth = rowWidthMap.values().stream().mapToInt(v -> v).max().orElse(0);
        int x = horizontalOffset;
        int y = verticalOffset;
        layerIndex = 0;
        if (log.isTraceEnabled()) {
            log.trace("layerMaxHeights {}", rowMaxHeightMap);
        }
        for (LV<V>[] lVArray : layersArray) {
            int previousVertexWidth = 0;
            x += (widestRowWidth - (Integer)rowWidthMap.get(layerIndex)) / 2;
            y += (Integer)rowMaxHeightMap.get(layerIndex) / 2;
            if (layerIndex > 0) {
                y += (Integer)rowMaxHeightMap.get(layerIndex - 1) / 2;
            }
            int rowWidth = 0;
            for (LV EiglspergerVertex : lVArray) {
                int vertexWidth = 0;
                if (!(EiglspergerVertex instanceof SyntheticLV)) {
                    vertexWidth = (int)((Rectangle)this.vertexShapeFunction.apply(EiglspergerVertex.getVertex())).width;
                }
                rowWidth = (x += previousVertexWidth / 2 + vertexWidth / 2 + horizontalOffset) + vertexWidth / 2;
                log.trace("layerIndex {} y is {}", (Object)layerIndex, (Object)y);
                previousVertexWidth = vertexWidth;
            }
            totalWidth = Math.max(totalWidth, rowWidth);
            x = horizontalOffset;
            totalHeight = (y += verticalOffset) + (Integer)rowMaxHeightMap.get(layerIndex) / 2;
            ++layerIndex;
        }
        int n3 = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxX = -1;
        int n4 = -1;
        for (Point p : vertexPointMap.values()) {
            n2 = Math.min((int)p.x, n2);
            maxX = Math.max((int)p.x, maxX);
            minY = Math.min((int)p.y, minY);
            n = Math.max((int)p.y, n);
        }
        void var36_54 = n + verticalOffset;
        int pointRangeWidth = (maxX += horizontalOffset) - n2;
        int pointRangeHeight = var36_54 - minY;
        int offsetX = 0;
        int offsetY = 0;
        if (n2 < 0) {
            offsetX += -n2 + horizontalOffset;
        }
        if (minY < 0) {
            offsetY += -minY + verticalOffset;
        }
        pointRangeWidth = (int)((double)pointRangeWidth * 1.1);
        pointRangeHeight = (int)((double)pointRangeHeight * 1.1);
        int maxDimension = Math.max(totalWidth, totalHeight);
        this.layoutModel.setSize(this.multiComponent ? totalWidth : Math.max(maxDimension, this.layoutModel.getWidth()), Math.max(maxDimension, this.layoutModel.getHeight()));
        long pointsSetTime = System.currentTimeMillis();
        double scalex = (double)this.layoutModel.getWidth() / (double)pointRangeWidth;
        double scaley = (double)this.layoutModel.getHeight() / (double)pointRangeHeight;
        for (Map.Entry entry : vertexPointMap.entrySet()) {
            Point p = (Point)entry.getValue();
            Point q = Point.of(((double)offsetX + p.x) * scalex, ((double)offsetY + p.y) * scaley);
            entry.setValue(q);
        }
        this.svGraph.vertexSet().forEach(v -> v.setPoint((Point)vertexPointMap.get(v)));
        if (this.postStraighten) {
            synthetics.alignArticulatedEdges();
        }
        List articulatedEdges = synthetics.makeArticulatedEdges();
        HashSet feedbackEdges = new HashSet();
        feedbackArcs.forEach(a -> feedbackEdges.add(a.getEdge()));
        articulatedEdges.stream().filter(ae -> feedbackEdges.contains(ae.getEdge())).forEach(ae -> {
            this.svGraph.removeEdge(ae);
            ArticulatedEdge reversed = ae.reversed();
            this.svGraph.addEdge(reversed.getSource(), reversed.getTarget(), reversed);
        });
        for (ArticulatedEdge ae2 : articulatedEdges) {
            ArrayList<Point> points = new ArrayList<Point>();
            if (feedbackEdges.contains(ae2.getEdge())) {
                points.add(ae2.getTarget().getPoint());
                points.addAll(ae2.reversed().getIntermediatePoints());
                points.add(ae2.getSource().getPoint());
            } else {
                points.add(ae2.getSource().getPoint());
                points.addAll(ae2.getIntermediatePoints());
                points.add(ae2.getTarget().getPoint());
            }
            this.edgePointMap.put(ae2.edge, points);
        }
        long articulatedEdgeTime = System.currentTimeMillis();
        log.trace("articulated edges took {}", (Object)(articulatedEdgeTime - pointsSetTime));
        if (this.cancelled) {
            log.debug("interrupted before setting layoutModel from svGraph, cancelled: {}", (Object)this.cancelled);
            return;
        }
        this.svGraph.vertexSet().forEach(v -> this.layoutModel.set(v.getVertex(), v.getPoint()));
    }

    private static <V> Rectangle maxVertexBounds(LV<V>[][] layers, Function<V, Rectangle> vertexShapeFunction) {
        Rectangle maxVertexBounds = Rectangle.IDENTITY;
        LV<V>[][] lVArray = layers;
        int n = lVArray.length;
        for (int i = 0; i < n; ++i) {
            LV<V>[] layer;
            for (LV<V> vlv : layer = lVArray[i]) {
                if (vlv instanceof SyntheticLV) continue;
                Rectangle bounds = vertexShapeFunction.apply(vlv.getVertex());
                int width = (int)Math.max(bounds.width, maxVertexBounds.width);
                int height = (int)Math.max(bounds.height, maxVertexBounds.height);
                maxVertexBounds = Rectangle.of(width, height);
            }
        }
        return maxVertexBounds;
    }

    private static <V> Rectangle avgVertexBounds(LV<V>[][] layers, Function<V, Rectangle> vertexShapeFunction) {
        LongSummaryStatistics w = new LongSummaryStatistics();
        LongSummaryStatistics h = new LongSummaryStatistics();
        LV<V>[][] lVArray = layers;
        int n = lVArray.length;
        for (int i = 0; i < n; ++i) {
            LV<V>[] layer;
            for (LV<V> vlv : layer = lVArray[i]) {
                if (vlv instanceof SyntheticLV) continue;
                Rectangle bounds = vertexShapeFunction.apply(vlv.getVertex());
                w.accept((int)bounds.width);
                h.accept((int)bounds.height);
            }
        }
        return Rectangle.of((int)w.getAverage(), (int)h.getAverage());
    }

    static {
        PropertyLoader.load();
    }

    public static class Builder<V, E, T extends ExtendedEiglspergerRunnable<V, E>, B extends Builder<V, E, T, B>>
    extends EiglspergerRunnable.Builder<V, E, T, B> {
        boolean doUpLeft;
        boolean doDownLeft;
        boolean doUpRight;
        boolean doDownRight;

        public B doUpLeft(boolean doUpLeft) {
            this.doUpLeft = doUpLeft;
            return (B)((Builder)this.self());
        }

        public B doUpRight(boolean doUpRight) {
            this.doUpRight = doUpRight;
            return (B)((Builder)this.self());
        }

        public B doDownLeft(boolean doDownLeft) {
            this.doDownLeft = doDownLeft;
            return (B)((Builder)this.self());
        }

        public B doDownRight(boolean doDownRight) {
            this.doDownRight = doDownRight;
            return (B)((Builder)this.self());
        }

        @Override
        public T build() {
            return (T)new ExtendedEiglspergerRunnable(this);
        }
    }
}

