/*-
 * Copyright (C) 2008 Erik Larsson
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package org.catacombae.hfsexplorer;

import java.io.File;
import javax.swing.filechooser.FileFilter;

/**
 *
 * @author Erik Larsson
 */
public class PrefixFileFilter extends FileFilter {
    private final String description;
    private final String prefix;

    public PrefixFileFilter(String description, String prefix) {
        this.description = description;
        this.prefix = prefix;
    }

    @Override
    public boolean accept(File f) {
       if(f.isDirectory())
            return true;

        if(f.getName().startsWith(prefix))
            return true;
        return false;
    }

    @Override
    public String getDescription() {
        return description;
    }

}
