/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui.map.tile;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import tim.prune.gui.map.MapSource;

public class TileDef {
    public final MapSource _mapSource;
    public final int _layerIdx;
    public final int _x;
    public final int _y;
    public final int _zoom;

    public TileDef(MapSource mapSource, int n, int n2, int n3, int n4) {
        this._mapSource = mapSource;
        this._layerIdx = n;
        this._x = n2;
        this._y = n3;
        this._zoom = n4;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TileDef tileDef = (TileDef)object;
        return this._layerIdx == tileDef._layerIdx && this._x == tileDef._x && this._y == tileDef._y && this._zoom == tileDef._zoom && this._mapSource.getName().equals(tileDef._mapSource.getName());
    }

    public int hashCode() {
        return Objects.hash(this._mapSource.getName(), this._layerIdx, this._x, this._y, this._zoom);
    }

    public String toString() {
        return "TileDef{layer=" + this._layerIdx + ", x=" + this._x + ", y=" + this._y + ", zoom=" + this._zoom + '}';
    }

    public TileDef zoomOut() {
        return new TileDef(this._mapSource, this._layerIdx, this._x / 2, this._y / 2, this._zoom - 1);
    }

    public TileDef zoomIn(int n) {
        return new TileDef(this._mapSource, this._layerIdx, this._x * 2 + n % 2, this._y * 2 + n / 2, this._zoom + 1);
    }

    public URL getUrl() {
        try {
            return new URL(this._mapSource.makeURL(this._layerIdx, this._zoom, this._x, this._y));
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public String getFilePath() {
        return this._mapSource.makeFilePath(this._layerIdx, this._zoom, this._x, this._y);
    }
}

