/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtSourceFileLinesMapping;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005H\u0016J\u001c\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000f2\u0006\u0010\u0010\u001a\u00020\u0005H\u0016J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0012\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/KtSourceFileLinesMappingFromLineStartOffsets;", "Lorg/jetbrains/kotlin/KtSourceFileLinesMapping;", "lineStartOffsets", "", "lastOffset", "", "<init>", "([II)V", "getLineStartOffsets", "()[I", "getLastOffset", "()I", "getLineStartOffset", "line", "getLineAndColumnByOffset", "Lkotlin/Pair;", "offset", "getLineByOffset", "linesCount", "getLinesCount", "frontend.common"})
public class KtSourceFileLinesMappingFromLineStartOffsets
implements KtSourceFileLinesMapping {
    @NotNull
    private final int[] lineStartOffsets;
    private final int lastOffset;

    public KtSourceFileLinesMappingFromLineStartOffsets(@NotNull int[] lineStartOffsets, int lastOffset) {
        Intrinsics.checkNotNullParameter((Object)lineStartOffsets, (String)"lineStartOffsets");
        this.lineStartOffsets = lineStartOffsets;
        this.lastOffset = lastOffset;
    }

    @NotNull
    public final int[] getLineStartOffsets() {
        return this.lineStartOffsets;
    }

    @Override
    public int getLastOffset() {
        return this.lastOffset;
    }

    @Override
    public int getLineStartOffset(int line) {
        return this.lineStartOffsets[line];
    }

    @Override
    @NotNull
    public Pair<Integer, Integer> getLineAndColumnByOffset(int offset) {
        int lineNumber = this.getLineByOffset(offset);
        if (lineNumber < 0) {
            return TuplesKt.to((Object)-1, (Object)-1);
        }
        int lineStartOffset = this.lineStartOffsets[lineNumber];
        return TuplesKt.to((Object)lineNumber, (Object)(offset - lineStartOffset));
    }

    @Override
    public int getLineByOffset(int offset) {
        int index = ArraysKt.binarySearch$default((int[])this.lineStartOffsets, (int)offset, (int)0, (int)0, (int)6, null);
        return index >= 0 ? index : -index - 2;
    }

    @Override
    public int getLinesCount() {
        return this.lineStartOffsets.length;
    }
}

