/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport.ext;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import org.jruby.Ruby;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBoolean;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Convert;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.ext.JavaExtensions;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.Inspector;
import org.jruby.util.RubyStringBuilder;

public abstract class JavaLangReflect {
    private static final Object[] NO_ARGS = new Object[0];

    public static void define(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        JavaExtensions.put(runtime2, java.lang.reflect.AccessibleObject.class, proxy2 -> proxy2.defineMethods(context, AccessibleObject.class));
        JavaExtensions.put(runtime2, java.lang.reflect.Constructor.class, proxy2 -> proxy2.defineMethods(context, Constructor.class));
        JavaExtensions.put(runtime2, java.lang.reflect.Field.class, proxy2 -> proxy2.defineMethods(context, Field.class));
        JavaExtensions.put(runtime2, java.lang.reflect.Method.class, proxy2 -> proxy2.defineMethods(context, Method.class));
    }

    private static Object unwrapJavaObject(IRubyObject object) {
        return JavaUtil.unwrapJavaValue(object);
    }

    private static Object convertValueToJava(java.lang.reflect.Field field, IRubyObject value2) {
        Object val = value2.dataGetStruct();
        if (val instanceof JavaObject) {
            value2 = (IRubyObject)val;
        }
        return value2.toJava(field.getType());
    }

    static RubyBoolean isAbstract(ThreadContext context, IRubyObject self2, int mod) {
        return Convert.asBoolean(context, Modifier.isAbstract(mod));
    }

    static RubyBoolean isPublic(ThreadContext context, IRubyObject self2, int mod) {
        return Convert.asBoolean(context, Modifier.isPublic(mod));
    }

    static RubyBoolean isProtected(ThreadContext context, IRubyObject self2, int mod) {
        return Convert.asBoolean(context, Modifier.isProtected(mod));
    }

    static RubyBoolean isPrivate(ThreadContext context, IRubyObject self2, int mod) {
        return Convert.asBoolean(context, Modifier.isPrivate(mod));
    }

    static RubyBoolean isFinal(ThreadContext context, IRubyObject self2, int mod) {
        return Convert.asBoolean(context, Modifier.isFinal(mod));
    }

    static RubyBoolean isStatic(ThreadContext context, IRubyObject self2, int mod) {
        return Convert.asBoolean(context, Modifier.isStatic(mod));
    }

    @JRubyClass(name={"Java::JavaLangReflect::Method"})
    public static class Method {
        @JRubyMethod
        public static IRubyObject return_type(ThreadContext context, IRubyObject self2) {
            java.lang.reflect.Method thiz = (java.lang.reflect.Method)JavaUtil.unwrapJavaObject(self2);
            return JavaUtil.convertJavaToUsableRubyObject(context.runtime, thiz.getReturnType());
        }

        @JRubyMethod
        public static IRubyObject argument_types(ThreadContext context, IRubyObject self2) {
            java.lang.reflect.Method thiz = (java.lang.reflect.Method)JavaUtil.unwrapJavaObject(self2);
            return JavaUtil.convertJavaToUsableRubyObject(context.runtime, thiz.getParameterTypes());
        }

        @JRubyMethod(rest=true)
        public static IRubyObject invoke(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
            Object[] javaArgs;
            Object target2;
            java.lang.reflect.Method method2 = (java.lang.reflect.Method)JavaUtil.unwrapJavaObject(self2);
            if (args2.length == 0) {
                target2 = null;
                javaArgs = NO_ARGS;
            } else {
                target2 = JavaLangReflect.unwrapJavaObject(args2[0]);
                javaArgs = JavaUtil.convertArguments(args2, method2.getParameterTypes(), 1);
            }
            try {
                return JavaUtil.convertJavaToUsableRubyObject(context.runtime, method2.invoke(target2, javaArgs));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                Helpers.throwException(e);
                return null;
            }
        }

        @JRubyMethod(rest=true)
        public static IRubyObject invoke_static(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
            java.lang.reflect.Method method2 = (java.lang.reflect.Method)JavaUtil.unwrapJavaObject(self2);
            Object[] javaArgs = JavaUtil.convertArguments(args2, method2.getParameterTypes());
            try {
                return JavaUtil.convertJavaToUsableRubyObject(context.runtime, method2.invoke(null, javaArgs));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                Helpers.throwException(e);
                return null;
            }
        }

        @JRubyMethod(name={"abstract?"})
        public static IRubyObject abstract_p(ThreadContext context, IRubyObject self2) {
            java.lang.reflect.Field thiz = (java.lang.reflect.Field)JavaUtil.unwrapJavaObject(self2);
            return JavaLangReflect.isAbstract(context, self2, thiz.getModifiers());
        }

        @Deprecated
        public static IRubyObject abstract_p(IRubyObject self2) {
            return Method.abstract_p(((RubyBasicObject)self2).getCurrentContext(), self2);
        }

        @JRubyMethod(name={"public?"})
        public static IRubyObject public_p(ThreadContext context, IRubyObject self2) {
            java.lang.reflect.Method thiz = (java.lang.reflect.Method)JavaUtil.unwrapJavaObject(self2);
            return JavaLangReflect.isPublic(context, self2, thiz.getModifiers());
        }

        @Deprecated
        public static IRubyObject public_p(IRubyObject self2) {
            return Method.public_p(((RubyBasicObject)self2).getCurrentContext(), self2);
        }

        @JRubyMethod(name={"protected?"})
        public static IRubyObject protected_p(ThreadContext context, IRubyObject self2) {
            java.lang.reflect.Method thiz = (java.lang.reflect.Method)JavaUtil.unwrapJavaObject(self2);
            return JavaLangReflect.isProtected(context, self2, thiz.getModifiers());
        }

        @Deprecated
        public static IRubyObject protected_p(IRubyObject self2) {
            return Method.protected_p(((RubyBasicObject)self2).getCurrentContext(), self2);
        }

        @JRubyMethod(name={"private?"})
        public static IRubyObject private_p(ThreadContext context, IRubyObject self2) {
            java.lang.reflect.Method thiz = (java.lang.reflect.Method)JavaUtil.unwrapJavaObject(self2);
            return JavaLangReflect.isPrivate(context, self2, thiz.getModifiers());
        }

        @Deprecated
        public static IRubyObject private_p(IRubyObject self2) {
            return Method.private_p(((RubyBasicObject)self2).getCurrentContext(), self2);
        }

        @JRubyMethod(name={"final?"})
        public static IRubyObject final_p(ThreadContext context, IRubyObject self2) {
            java.lang.reflect.Method thiz = (java.lang.reflect.Method)JavaUtil.unwrapJavaObject(self2);
            return JavaLangReflect.isFinal(context, self2, thiz.getModifiers());
        }

        @Deprecated
        public static IRubyObject final_p(IRubyObject self2) {
            return Method.final_p(((RubyBasicObject)self2).getCurrentContext(), self2);
        }

        @JRubyMethod(name={"static?"})
        public static IRubyObject static_p(ThreadContext context, IRubyObject self2) {
            java.lang.reflect.Method thiz = (java.lang.reflect.Method)JavaUtil.unwrapJavaObject(self2);
            return JavaLangReflect.isStatic(context, self2, thiz.getModifiers());
        }

        @Deprecated(since="10.0")
        public static IRubyObject static_p(IRubyObject self2) {
            return Method.static_p(((RubyBasicObject)self2).getCurrentContext(), self2);
        }
    }

    @JRubyClass(name={"Java::JavaLangReflect::Field"})
    public static class Field {
        @JRubyMethod
        public static IRubyObject value_type(ThreadContext context, IRubyObject self2) {
            java.lang.reflect.Field field = (java.lang.reflect.Field)JavaUtil.unwrapJavaObject(self2);
            return JavaUtil.convertJavaToUsableRubyObject(context.runtime, field.getType().getName());
        }

        @JRubyMethod
        public static IRubyObject value(ThreadContext context, IRubyObject self2, IRubyObject obj) {
            java.lang.reflect.Field field = (java.lang.reflect.Field)JavaUtil.unwrapJavaObject(self2);
            Object target2 = Modifier.isStatic(field.getModifiers()) ? null : JavaLangReflect.unwrapJavaObject(obj);
            try {
                return JavaUtil.convertJavaToUsableRubyObject(context.runtime, field.get(target2));
            }
            catch (IllegalAccessException e) {
                Helpers.throwException(e);
                return null;
            }
        }

        @JRubyMethod
        public static IRubyObject set_value(ThreadContext context, IRubyObject self2, IRubyObject obj, IRubyObject value2) {
            java.lang.reflect.Field field = (java.lang.reflect.Field)JavaUtil.unwrapJavaObject(self2);
            Object target2 = Modifier.isStatic(field.getModifiers()) ? null : JavaLangReflect.unwrapJavaObject(obj);
            Object javaValue = JavaLangReflect.convertValueToJava(field, value2);
            try {
                field.set(target2, javaValue);
            }
            catch (IllegalAccessException e) {
                Helpers.throwException(e);
                return null;
            }
            return context.nil;
        }

        @JRubyMethod
        public static IRubyObject static_value(ThreadContext context, IRubyObject self2) {
            java.lang.reflect.Field field = (java.lang.reflect.Field)JavaUtil.unwrapJavaObject(self2);
            try {
                return JavaUtil.convertJavaToUsableRubyObject(context.runtime, field.get(null));
            }
            catch (IllegalAccessException e) {
                Helpers.throwException(e);
                return null;
            }
        }

        @JRubyMethod
        public static IRubyObject set_static_value(ThreadContext context, IRubyObject self2, IRubyObject value2) {
            java.lang.reflect.Field field = (java.lang.reflect.Field)JavaUtil.unwrapJavaObject(self2);
            Object javaValue = JavaLangReflect.convertValueToJava(field, value2);
            try {
                field.set(null, javaValue);
            }
            catch (IllegalAccessException e) {
                Helpers.throwException(e);
                return null;
            }
            return context.nil;
        }

        @JRubyMethod(name={"public?"})
        public static IRubyObject public_p(ThreadContext context, IRubyObject self2) {
            java.lang.reflect.Field thiz = (java.lang.reflect.Field)JavaUtil.unwrapJavaObject(self2);
            return JavaLangReflect.isPublic(context, self2, thiz.getModifiers());
        }

        @Deprecated
        public static IRubyObject public_p(IRubyObject self2) {
            return Field.public_p(((RubyBasicObject)self2).getCurrentContext(), self2);
        }

        @JRubyMethod(name={"protected?"})
        public static IRubyObject protected_p(ThreadContext context, IRubyObject self2) {
            java.lang.reflect.Field thiz = (java.lang.reflect.Field)JavaUtil.unwrapJavaObject(self2);
            return JavaLangReflect.isProtected(context, self2, thiz.getModifiers());
        }

        @Deprecated
        public static IRubyObject protected_p(IRubyObject self2) {
            return Field.protected_p(((RubyBasicObject)self2).getCurrentContext(), self2);
        }

        @JRubyMethod(name={"private?"})
        public static IRubyObject private_p(ThreadContext context, IRubyObject self2) {
            java.lang.reflect.Field thiz = (java.lang.reflect.Field)JavaUtil.unwrapJavaObject(self2);
            return JavaLangReflect.isPrivate(context, self2, thiz.getModifiers());
        }

        @Deprecated
        public static IRubyObject private_p(IRubyObject self2) {
            return Field.private_p(((RubyBasicObject)self2).getCurrentContext(), self2);
        }

        @JRubyMethod(name={"final?"})
        public static IRubyObject final_p(ThreadContext context, IRubyObject self2) {
            java.lang.reflect.Field thiz = (java.lang.reflect.Field)JavaUtil.unwrapJavaObject(self2);
            return JavaLangReflect.isFinal(context, self2, thiz.getModifiers());
        }

        @Deprecated
        public static IRubyObject final_p(IRubyObject self2) {
            return Field.final_p(((RubyBasicObject)self2).getCurrentContext(), self2);
        }

        @JRubyMethod(name={"static?"})
        public static IRubyObject static_p(ThreadContext context, IRubyObject self2) {
            java.lang.reflect.Field thiz = (java.lang.reflect.Field)JavaUtil.unwrapJavaObject(self2);
            return JavaLangReflect.isStatic(context, self2, thiz.getModifiers());
        }

        @Deprecated
        public static IRubyObject static_p(IRubyObject self2) {
            return Field.static_p(((RubyBasicObject)self2).getCurrentContext(), self2);
        }
    }

    @JRubyClass(name={"Java::JavaLangReflect::Constructor"})
    public static class Constructor {
        @JRubyMethod
        public static IRubyObject return_type(ThreadContext context, IRubyObject self2) {
            return context.nil;
        }

        @JRubyMethod
        public static IRubyObject argument_types(ThreadContext context, IRubyObject self2) {
            java.lang.reflect.Constructor thiz = (java.lang.reflect.Constructor)JavaUtil.unwrapJavaObject(self2);
            return JavaUtil.convertJavaToUsableRubyObject(context.runtime, thiz.getParameterTypes());
        }

        @JRubyMethod(name={"newInstance", "new_instance"}, rest=true)
        public static IRubyObject new_instance(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
            java.lang.reflect.Constructor thiz = (java.lang.reflect.Constructor)JavaUtil.unwrapJavaObject(self2);
            Object[] javaArgs = args2.length == 0 ? NO_ARGS : JavaUtil.convertArguments(args2, thiz.getParameterTypes(), 0);
            try {
                return JavaUtil.convertJavaToUsableRubyObject(context.runtime, thiz.newInstance(javaArgs));
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                Helpers.throwException(e);
                return null;
            }
        }

        @JRubyMethod(name={"public?"})
        public static IRubyObject public_p(ThreadContext context, IRubyObject self2) {
            java.lang.reflect.Constructor thiz = (java.lang.reflect.Constructor)JavaUtil.unwrapJavaObject(self2);
            return JavaLangReflect.isPublic(context, self2, thiz.getModifiers());
        }

        @Deprecated(since="9.4")
        public static IRubyObject public_p(IRubyObject self2) {
            return Constructor.public_p(((RubyBasicObject)self2).getCurrentContext(), self2);
        }

        @JRubyMethod(name={"protected?"})
        public static IRubyObject protected_p(ThreadContext context, IRubyObject self2) {
            java.lang.reflect.Constructor thiz = (java.lang.reflect.Constructor)JavaUtil.unwrapJavaObject(self2);
            return JavaLangReflect.isProtected(context, self2, thiz.getModifiers());
        }

        @Deprecated
        public static IRubyObject protected_p(IRubyObject self2) {
            return Constructor.protected_p(((RubyBasicObject)self2).getCurrentContext(), self2);
        }

        @JRubyMethod(name={"private?"})
        public static IRubyObject private_p(ThreadContext context, IRubyObject self2) {
            java.lang.reflect.Constructor thiz = (java.lang.reflect.Constructor)JavaUtil.unwrapJavaObject(self2);
            return JavaLangReflect.isPrivate(context, self2, thiz.getModifiers());
        }

        @Deprecated
        public static IRubyObject private_p(IRubyObject self2) {
            return Constructor.private_p(((RubyBasicObject)self2).getCurrentContext(), self2);
        }

        @JRubyMethod(name={"final?"})
        public static IRubyObject final_p(ThreadContext context, IRubyObject self2) {
            java.lang.reflect.Constructor thiz = (java.lang.reflect.Constructor)JavaUtil.unwrapJavaObject(self2);
            return JavaLangReflect.isFinal(context, self2, thiz.getModifiers());
        }

        @Deprecated
        public static IRubyObject final_p(IRubyObject self2) {
            return Constructor.final_p(((RubyBasicObject)self2).getCurrentContext(), self2);
        }

        @JRubyMethod(name={"static?"})
        public static IRubyObject static_p(ThreadContext context, IRubyObject self2) {
            java.lang.reflect.Constructor thiz = (java.lang.reflect.Constructor)JavaUtil.unwrapJavaObject(self2);
            return JavaLangReflect.isStatic(context, self2, thiz.getModifiers());
        }

        @Deprecated
        public static IRubyObject static_p(IRubyObject self2) {
            return Constructor.static_p(((RubyBasicObject)self2).getCurrentContext(), self2);
        }
    }

    @JRubyClass(name={"Java::JavaLangReflect::AccessibleObject"})
    public static class AccessibleObject {
        @JRubyMethod
        public static IRubyObject inspect(ThreadContext context, IRubyObject self2) {
            java.lang.reflect.AccessibleObject obj = (java.lang.reflect.AccessibleObject)JavaUtil.unwrapJavaObject(self2);
            RubyString buf = Inspector.inspectPrefix(context, self2.getMetaClass());
            RubyStringBuilder.cat(context.runtime, buf, 32);
            RubyStringBuilder.cat(context.runtime, buf, obj.toString());
            RubyStringBuilder.cat(context.runtime, buf, Inspector.GT);
            return buf;
        }
    }
}

