/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data;

import com.webauthn4j.util.ArrayUtil;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class AuthenticationRequest {
    private final byte[] credentialId;
    private final byte[] userHandle;
    private final byte[] authenticatorData;
    private final byte[] clientDataJSON;
    private final String clientExtensionsJSON;
    private final byte[] signature;

    public AuthenticationRequest(@Nullable byte[] credentialId, @Nullable byte[] userHandle, @Nullable byte[] authenticatorData, @Nullable byte[] clientDataJSON, @Nullable String clientExtensionsJSON, @Nullable byte[] signature) {
        this.credentialId = ArrayUtil.clone(credentialId);
        this.userHandle = ArrayUtil.clone(userHandle);
        this.authenticatorData = ArrayUtil.clone(authenticatorData);
        this.clientDataJSON = ArrayUtil.clone(clientDataJSON);
        this.clientExtensionsJSON = clientExtensionsJSON;
        this.signature = ArrayUtil.clone(signature);
    }

    public AuthenticationRequest(@Nullable byte[] credentialId, @Nullable byte[] authenticatorData, @Nullable byte[] clientDataJSON, @Nullable String clientExtensionsJSON, @Nullable byte[] signature) {
        this(credentialId, null, authenticatorData, clientDataJSON, clientExtensionsJSON, signature);
    }

    public AuthenticationRequest(@Nullable byte[] credentialId, @Nullable byte[] userHandle, @Nullable byte[] authenticatorData, @Nullable byte[] clientDataJSON, @Nullable byte[] signature) {
        this(credentialId, userHandle, authenticatorData, clientDataJSON, null, signature);
    }

    public AuthenticationRequest(@Nullable byte[] credentialId, @Nullable byte[] authenticatorData, @Nullable byte[] clientDataJSON, @Nullable byte[] signature) {
        this(credentialId, null, authenticatorData, clientDataJSON, signature);
    }

    @Nullable
    public byte[] getCredentialId() {
        return ArrayUtil.clone(this.credentialId);
    }

    @Nullable
    public byte[] getUserHandle() {
        return ArrayUtil.clone(this.userHandle);
    }

    @Nullable
    public byte[] getAuthenticatorData() {
        return ArrayUtil.clone(this.authenticatorData);
    }

    @Nullable
    public byte[] getClientDataJSON() {
        return ArrayUtil.clone(this.clientDataJSON);
    }

    @Nullable
    public String getClientExtensionsJSON() {
        return this.clientExtensionsJSON;
    }

    @Nullable
    public byte[] getSignature() {
        return ArrayUtil.clone(this.signature);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticationRequest that = (AuthenticationRequest)o;
        return Arrays.equals(this.credentialId, that.credentialId) && Arrays.equals(this.userHandle, that.userHandle) && Arrays.equals(this.authenticatorData, that.authenticatorData) && Arrays.equals(this.clientDataJSON, that.clientDataJSON) && Objects.equals(this.clientExtensionsJSON, that.clientExtensionsJSON) && Arrays.equals(this.signature, that.signature);
    }

    public int hashCode() {
        int result = Objects.hash(this.clientExtensionsJSON);
        result = 31 * result + Arrays.hashCode(this.credentialId);
        result = 31 * result + Arrays.hashCode(this.userHandle);
        result = 31 * result + Arrays.hashCode(this.authenticatorData);
        result = 31 * result + Arrays.hashCode(this.clientDataJSON);
        result = 31 * result + Arrays.hashCode(this.signature);
        return result;
    }

    public String toString() {
        return "AuthenticationRequest(credentialId=" + ArrayUtil.toHexString(this.credentialId) + ", userHandle=" + ArrayUtil.toHexString(this.userHandle) + ", authenticatorData=" + ArrayUtil.toHexString(this.authenticatorData) + ", clientDataJSON=" + ArrayUtil.toHexString(this.clientDataJSON) + ", clientExtensionsJSON=" + this.clientExtensionsJSON + ", signature=" + ArrayUtil.toHexString(this.signature) + ")";
    }
}

