/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.regression.sgd;

import java.util.SplittableRandom;
import org.tribuo.math.la.DenseVector;
import org.tribuo.math.la.SparseVector;

public class Util {
    public static void shuffleInPlace(SparseVector[] features, DenseVector[] regressors, double[] weights, SplittableRandom rng) {
        int size;
        for (int i = size = features.length; i > 1; --i) {
            int j = rng.nextInt(i);
            SparseVector tmpFeature = features[i - 1];
            features[i - 1] = features[j];
            features[j] = tmpFeature;
            DenseVector tmpRegressors = regressors[i - 1];
            regressors[i - 1] = regressors[j];
            regressors[j] = tmpRegressors;
            double tmpWeight = weights[i - 1];
            weights[i - 1] = weights[j];
            weights[j] = tmpWeight;
        }
    }

    public static void shuffleInPlace(SparseVector[] features, DenseVector[] regressors, double[] weights, int[] indices, SplittableRandom rng) {
        int size;
        for (int i = size = features.length; i > 1; --i) {
            int j = rng.nextInt(i);
            SparseVector tmpFeature = features[i - 1];
            features[i - 1] = features[j];
            features[j] = tmpFeature;
            DenseVector tmpLabel = regressors[i - 1];
            regressors[i - 1] = regressors[j];
            regressors[j] = tmpLabel;
            double tmpWeight = weights[i - 1];
            weights[i - 1] = weights[j];
            weights[j] = tmpWeight;
            int tmpIndex = indices[i - 1];
            indices[i - 1] = indices[j];
            indices[j] = tmpIndex;
        }
    }
}

