/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.engine.processor;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ml.engine.annotation.Processor;
import org.opensearch.ml.engine.processor.AbstractMLProcessor;
import org.opensearch.ml.engine.processor.MLProcessorType;

@Processor(value=MLProcessorType.EXTRACT_JSON)
public class MLExtractJsonProcessor
extends AbstractMLProcessor {
    @Generated
    private static final Logger log = LogManager.getLogger(MLExtractJsonProcessor.class);
    private static final String EXTRACT_TYPE_AUTO = "auto";
    private static final String EXTRACT_TYPE_OBJECT = "object";
    private static final String EXTRACT_TYPE_ARRAY = "array";
    private final String extractType;
    private final Object defaultValue;
    private final ObjectMapper mapper;

    public MLExtractJsonProcessor(Map<String, Object> config) {
        super(config);
        this.extractType = (String)config.getOrDefault("extract_type", EXTRACT_TYPE_AUTO);
        this.defaultValue = config.get("default");
        this.mapper = new ObjectMapper();
    }

    @Override
    protected void validateConfig() {
        String type;
        if (this.config.containsKey("extract_type") && !EXTRACT_TYPE_AUTO.equalsIgnoreCase(type = (String)this.config.get("extract_type")) && !EXTRACT_TYPE_OBJECT.equalsIgnoreCase(type) && !EXTRACT_TYPE_ARRAY.equalsIgnoreCase(type)) {
            throw new IllegalArgumentException("'extract_type' must be 'auto', 'object', or 'array', got: " + type);
        }
    }

    @Override
    public Object process(Object input) {
        if (!(input instanceof String)) {
            return input;
        }
        String text = (String)input;
        if (text.trim().isEmpty()) {
            return this.defaultValue != null ? this.defaultValue : input;
        }
        try {
            int start = this.findJsonStart(text);
            if (start < 0) {
                log.debug("No JSON found in text");
                return this.defaultValue != null ? this.defaultValue : input;
            }
            JsonNode jsonNode = this.mapper.readTree(text.substring(start));
            if (EXTRACT_TYPE_OBJECT.equalsIgnoreCase(this.extractType)) {
                if (jsonNode.isObject()) {
                    return this.mapper.convertValue((Object)jsonNode, Map.class);
                }
                log.debug("Expected JSON object but found {}", (Object)jsonNode.getNodeType());
                return this.defaultValue != null ? this.defaultValue : input;
            }
            if (EXTRACT_TYPE_ARRAY.equalsIgnoreCase(this.extractType)) {
                if (jsonNode.isArray()) {
                    return this.mapper.convertValue((Object)jsonNode, List.class);
                }
                log.debug("Expected JSON array but found {}", (Object)jsonNode.getNodeType());
                return this.defaultValue != null ? this.defaultValue : input;
            }
            if (jsonNode.isObject()) {
                return this.mapper.convertValue((Object)jsonNode, Map.class);
            }
            if (jsonNode.isArray()) {
                return this.mapper.convertValue((Object)jsonNode, List.class);
            }
            log.debug("JSON node is neither object nor array: {}", (Object)jsonNode.getNodeType());
            return this.defaultValue != null ? this.defaultValue : input;
        }
        catch (Exception e) {
            log.warn("Failed to extract JSON from text: {}", (Object)e.getMessage());
            return this.defaultValue != null ? this.defaultValue : input;
        }
    }

    private int findJsonStart(String text) {
        if (EXTRACT_TYPE_OBJECT.equalsIgnoreCase(this.extractType)) {
            return text.indexOf(123);
        }
        if (EXTRACT_TYPE_ARRAY.equalsIgnoreCase(this.extractType)) {
            return text.indexOf(91);
        }
        int startBrace = text.indexOf(123);
        int startBracket = text.indexOf(91);
        if (startBrace < 0) {
            return startBracket;
        }
        if (startBracket < 0) {
            return startBrace;
        }
        return Math.min(startBrace, startBracket);
    }
}

